/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import jp.terasoluna.utlib.TagUTUtil;
import junit.framework.TestCase;

/**
 * TrimTag ubN{bNXeXgB<br>
 * O<br>
 * Ȃ<br>
 * <br>
 */
public class TrimTagTest extends TestCase {

    //eXgΏ
    TrimTag tag = null;

    /**
     * Constructor for TrimTagTest.
     * @param arg0
     */
    public TrimTagTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = (TrimTag) TagUTUtil.create(TrimTag.class);
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testDoFormat01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() str:" test test test "<br>
     *         () zenkaku:false<br>
     *         
     * <br>
     * ҒlF(߂l) String:"test test test"<br>
     *         
     * <br>
     * strNullł͂Ȃꍇ̃eXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFormat01() throws Exception {

        // eXgݒ
        String str = " test test test ";

        // eXgs
        String result = tag.doFormat(str);

        // eXgʊmF
        assertEquals("test test test", result);

    } /* testDoFormat01 End */

    /**
     * testDoFormat02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() str:Null<br>
     *         
     * <br>
     * ҒlF(߂l) String:Null<br>
     *         
     * <br>
     * strNull̏ꍇ̃eXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFormat02() throws Exception {

        // eXgݒ
        String str = null;

        // eXgs
        String result = tag.doFormat(str);

        // eXgʊmF
        assertNull(result);

    } /* testDoFormat02 End */

    /**
     * testDoFormat03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() str:" @test test@test @"<br>
     *         () zenkaku:true<br>
     *         
     * <br>
     * ҒlF(߂l) String:"test test@test"<br>
     *         
     * <br>
     * strNullł͂ȂAzenkakutruȅꍇ
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFormat03() throws Exception {

        // eXgݒ
        String str = " @test test@test @";
        tag.setZenkaku(true);

        // eXgs
        String result = tag.doFormat(str);

        // eXgʊmF
        assertEquals("test test@test", result);

    }

    /**
     * testGetZenkaku01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() zenkaku:false<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * ZbgĂl擾ł邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetZenkaku01() throws Exception {

        // eXgݒ
        tag.zenkaku = false;

        //eXgs
        boolean result = tag.getZenkaku();

        //eXgʊmF
        assertFalse(result);

    }

    /**
     * testSetZenkaku01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() zenkaku:true<br>
     *         () zenkaku:false<br>
     *         
     * <br>
     * ҒlF(ԕω) zenkaku:true<br>
     *         
     * <br>
     * zenkakui[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetZenkaku01() throws Exception {

        // eXgݒ
        tag.zenkaku = false;

        //eXgs
        tag.setZenkaku(true);

        //eXgʊmF
        assertTrue(tag.zenkaku);

    }

} /* TrimTagTest Class End */
