/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.reset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.reset.ActionReset} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ANVpXPʂ̃Zbgp̐ݒێ Bean NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.reset.ActionReset
 */
public class ActionResetTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ActionResetTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ActionResetTest(String name) {
        super(name);
    }

    /**
     * testSetFieldReset01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() fieldReset:name="name"<br>
     *         () fieldResets:{}<br>
     *
     * <br>
     * ҒlF(ԕω) fieldResets:{"name"=FieldReset(name="name")}<br>
     *
     * <br>
     * FieldResetCX^XnameL[ACX^XlƂāAfieldResetsɒǉ邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetFieldReset01() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        FieldReset fr = new FieldReset();
        fr.setFieldName("name");

        //eXgs
        ar.setFieldReset(fr);
        //ʊmF
        Map result = (HashMap) UTUtil.getPrivateField(ar, "fieldResets");
        assertTrue(result.containsKey("name"));
        assertTrue(result.containsValue(fr));
    }

    /**
     * testGetPath01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:"path"<br>
     *
     * <br>
     * ҒlF(߂l) String:"path"<br>
     *
     * <br>
     * CX^Xϐpath̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetPath01() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        UTUtil.setPrivateField(ar, "path", "path");

        //eXgs
        //ʊmF
        assertEquals("path", ar.getPath());
    }

    /**
     * testSetPath01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() path:"path1"<br>
     *         () path:null<br>
     *
     * <br>
     * ҒlF(ԕω) path:"path1"<br>
     *
     * <br>
     * ̒lCX^Xϐpathɐݒ肳邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetPath01() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        //eXgs
        ar.setPath("path1");
        //ʊmF
        assertEquals("path1", UTUtil.getPrivateField(ar, "path"));
    }

    /**
     * testGetFieldNames01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() fieldResets:{"key1"=FieldReset,<br>
     *                 "key2"=FieldReset,<br>
     *                 "key3"=FieldReset}<br>
     *
     * <br>
     * ҒlF(߂l) Iterator:{"key1","key2","key3"}(s)<br>
     *
     * <br>
     * fieldResetsɕ̗vf݂ꍇASẴL[̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetFieldNames01() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        FieldReset fr = new FieldReset();

        Map<String, FieldReset> map = new TreeMap<String, FieldReset>();
        map.put("key1", fr);
        map.put("key2", fr);
        map.put("key3", fr);

        UTUtil.setPrivateField(ar, "fieldResets", map);

        //eXgs
        Iterator result = ar.getFieldNames();

        //ʊmF
        assertEquals("key1", (String) result.next());
        assertEquals("key2", (String) result.next());
        assertEquals("key3", (String) result.next());
        assertFalse(result.hasNext());
    }

    /**
     * testGetFieldNames02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() fieldResets:{"key1"=FieldReset}<br>
     *
     * <br>
     * ҒlF(߂l) Iterator:{"key1"}<br>
     *
     * <br>
     * fieldResets1̗vf݂ꍇÃL[̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetFieldNames02() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        FieldReset fr = new FieldReset();

        Map<String, FieldReset> map = new HashMap<String, FieldReset>();
        map.put("key1", fr);

        UTUtil.setPrivateField(ar, "fieldResets", map);

        //eXgs
        Iterator result = ar.getFieldNames();

        //ʊmF
        assertEquals("key1", (String) result.next());
        assertFalse(result.hasNext());
    }

    /**
     * testGetFieldNames03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() fieldResets:{}<br>
     *
     * <br>
     * ҒlF(߂l) Iterator:{}<br>
     *
     * <br>
     * fieldResetsɗvf݂ȂꍇAIterator擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetFieldNames03() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();

        Map map = new HashMap();

        UTUtil.setPrivateField(ar, "fieldResets", map);
        //eXgs
        Iterator result = ar.getFieldNames();
        //ʊmF
        assertFalse(result.hasNext());
    }

    /**
     * testIsSelectedField01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() fieldName:"aaa"<br>
     *         () fieldResets:{"name"=FieldReset(select = true)}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * fieldNameɎw肵OFieldReset݂ȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsSelectedField01() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        FieldReset fr = new FieldReset();
        fr.setFieldName("name");
        fr.setSelect(true);
        Map<String, FieldReset> map = new HashMap<String, FieldReset>();
        map.put("name", fr);
        UTUtil.setPrivateField(ar, "fieldResets", map);

        //eXgs
        //ʊmF
        assertFalse(ar.isSelectField("aaa"));
    }

    /**
     * testIsSelectedField02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() fieldName:"name"<br>
     *         () fieldResets:{"name"=FieldReset(select = true)}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * fieldNameɎw肵OFieldReset݂ꍇAFieldReset̃CX^Xϐselect̒l擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsSelectedField02() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();
        FieldReset fr = new FieldReset();
        fr.setSelect(true);

        Map<String, FieldReset> map = new HashMap<String, FieldReset>();
        map.put("name", fr);

        UTUtil.setPrivateField(ar, "fieldResets", map);

        //eXgs
        //ʊmF
        assertTrue(ar.isSelectField("name"));
    }

    /**
     * testIsSelectedField03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:null<br>
     *         () fieldResets:{}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * fieldNameɎw肵lnull̏ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsSelectedField03() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();

        //eXgs
        //ʊmF
        assertFalse(ar.isSelectField(null));
    }

    /**
     * testIsSelectedField04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() fieldName:""<br>
     *         () fieldResets:{}<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * fieldNameɎw肵l󕶎̏ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsSelectedField04() throws Exception {
        //ݒ
        ActionReset ar = new ActionReset();

        //eXgs
        //ʊmF
        assertFalse(ar.isSelectField(""));
    }

}
