/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts;

import java.text.MessageFormat;
import java.util.HashMap;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;

/**
 * {@link MessageFormatCacheMapFactory} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Struts̃oO(STR-2172)pHashMap(MessageFormatLbV)̃t@NgNXB<br>
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.MessageFormatCacheMapFactory
 */
public class MessageFormatCacheMapFactoryTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(MessageFormatCacheMapFactoryTest.class);
    }
    
    /**
     * s.
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    @SuppressWarnings("unchecked")
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
    }

    /**
     * Is.
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }
    
    /**
     * testGetInstance01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF(O) messageResources.messageFormatClone:Ȃ<br>
     *         
     * <br>
     * ҒlF(߂l) MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         
     * <br>
     * messageResources.messageFormatClone̐ݒ肪ꍇA
     * MessageFormatCloneReturnIfUseDateFormatMapԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance01() throws Exception {
        // O
        deleteProperty("messageResources.messageFormatClone");
        
        // eXg{
        HashMap<String,MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        
        // 
        assertEquals(MessageFormatCloneReturnIfUseDateFormatMap.class, map.getClass());
    }

    /**
     * testGetInstance02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF(O) messageResources.messageFormatClone:"enable"<br>
     *         
     * <br>
     * ҒlF(߂l) MessageFormatCloneReturnMapCX^X<br>
     *         
     * <br>
     * messageResources.messageFormatClone"enable"̏ꍇA
     * MessageFormatCloneReturnMapԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance02() throws Exception {
        // O
        addProperty("messageResources.messageFormatClone", "enable");
        
        // eXg{
        HashMap<String,MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        
        // 
        assertEquals(MessageFormatCloneReturnMap.class, map.getClass());
    }

    /**
     * testGetInstance03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF(O) messageResources.messageFormatClone:"dateFormatOnly"<br>
     *         
     * <br>
     * ҒlF(߂l) MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         
     * <br>
     * messageResources.messageFormatClone"dateFormatOnly"̏ꍇA
     * MessageFormatCloneReturnIfUseDateFormatMapԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance03() throws Exception {
        // O
        addProperty("messageResources.messageFormatClone", "dateFormatOnly");
        
        // eXg{
        HashMap<String,MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        
        // 
        assertEquals(MessageFormatCloneReturnIfUseDateFormatMap.class, map.getClass());
    }

    /**
     * testGetInstance04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF(O) messageResources.messageFormatClone:"disable"<br>
     *         
     * <br>
     * ҒlF(߂l) null<br>
     *         
     * <br>
     * messageResources.messageFormatClone"disable"̏ꍇA
     * nullԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance04() throws Exception {
        // O
        addProperty("messageResources.messageFormatClone", "disable");
        
        // eXg{
        HashMap<String,MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        
        // 
        assertNull(map);
    }

    /**
     * testGetInstance05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF(O) messageResources.messageFormatClone:"xxx"<br>
     *         
     * <br>
     * ҒlF(߂l) MessageFormatCloneReturnIfUseDateFormatMapCX^X<br>
     *         (ԕω) O:O<br>
     *                    xOF<br>
     *                    "messageResources.messageFormatClone = xxx is invalid. set \"enable\", \"disable\" or \"dateFormatOnly\"."<br>
     *                    xOF<br>
     *                    "use MessageFormatCloneReturnAtDateFormatOnlyMap."<br>
     *         
     * <br>
     * messageResources.messageFormatClone"dateFormatOnly"̏ꍇA
     * MessageFormatCloneReturnIfUseDateFormatMapԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetInstance05() throws Exception {
        // O
        addProperty("messageResources.messageFormatClone", "xxx");
        
        // eXg{
        HashMap<String,MessageFormat> map = MessageFormatCacheMapFactory.getInstance();
        
        // 
        assertEquals(MessageFormatCloneReturnIfUseDateFormatMap.class, map.getClass());
        assertTrue(LogUTUtil.checkWarn("messageResources.messageFormatClone = xxx is invalid. set \"enable\", \"disable\" or \"dateFormatOnly\"."));
        assertTrue(LogUTUtil.checkWarn("use MessageFormatCloneReturnAtDateFormatOnlyMap."));
    }

}
