/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.bind;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletRequest;

import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.xsd.SchemaValidator;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessage;
import jp.terasoluna.fw.oxm.xsd.message.ErrorMessages;
import jp.terasoluna.fw.web.rich.springmvc.bind.creator.exception.XMLRequestIOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.w3c.dom.Document;

/**
 * XML`̃NGXgf[^R}hIuWFNgɃoChNXB
 * <p>
 * ȉ̏ԂɍsB
 * <ol>
 * <li>XMLf[^̌``FbNiȗ\j</li>
 * <li>XMLIuWFNgւ̕ϊ</li>
 * </ol>
 * </p>
 * <p>
 * XMLf[^̌``FbNɂXMLXL[}gpB <br>
 * ۂ̌``FbNSchemaValidatorɏϏB<br>
 * ڍׂ{@link jp.terasoluna.fw.oxm.xsd.SchemaValidator}QƂ邱ƁB
 * </p>
 * <p>
 * XMLf[^IuWFNgɕϊ@\CastorgpB ڍׂCastorOXMapperImplNXQƂ邱ƁB
 * ۂXMLIuWFNg֕ϊ镔OXMapperɏϏB<br>
 * ڍׂ{@link jp.terasoluna.fw.oxm.mapper.OXMapper}QƂ邱ƁB
 * </p>
 * <p>
 * f[^oChŔG[͂QނAK؂ȃG[nhOsKvB<br>
 * G[̈ꗗȉɋL<br>
 * <ol>
 * <li>``FbNG[</li>
 * <li>OXMappingException</li>
 * </ol>
 * </p>
 * <p>
 * <u>``FbNG[̃nhO</u><br>
 * ``FbNG[ŐG[bZ[WABindExceptionɊi[B<br>
 * G[̏ڍׂ{@link jp.terasoluna.fw.oxm.xsd.xerces.XMLErrorReporterEx}QƂ邱ƁB
 * </p>
 * <p>
 * y``FbÑ\[Xohݒz<br>
 * <code><pre>
 *           typeMismatch.number= {0}ɂ{1}l͂Ă.
 *           typeMismatch.boolean= {0}ɂbooleanl͂Ă.
 *           typeMismatch.date= {0}ɂ͐t͂Ă.
 *           typeMismatch.numberMinRange= {0}ɂ{1}ȏ{2}l͂Ă.
 *           typeMismatch.numberMaxRange= {0}ɂ{1}ȉ{2}l͂Ă.
 * </pre></code>
 * </p>
 * <p>
 * <u>OXMappingExceptioñnhO</u><br>
 * f[^oChŔOׂ͂ĎsOłA {IɃnhOKv͂ȂB<br>
 * KvɉāAOnh̒`OXMappingExceptionA ܂͂̃TuNXGg邱ƁB
 * OXMappingException̏ڍׂ{@link jp.terasoluna.fw.oxm.exception.OXMappingException}QƂ邱ƁB
 * OnhȌڍׂ{@link org.springframework.web.servlet.handler.SimpleMappingExceptionResolver}QƂ邱ƁB
 * </p>
 * <p>
 * yOXMappingExceptionBean`z <br>
 * <code><pre>
 *          &lt;bean id=&quot;handlerExceptionResolver&quot;
 *                class=&quot;jp.terasoluna.fw.web.rich.springmvc.servlet.handler.SimpleMappingExceptionResolverEx&quot;&gt;
 *              &lt;property name=&quot;linkedExceptionMappings&quot;&gt;
 *                  &lt;map&gt;
 *                     &lt;entry key=&quot;jp.terasoluna.fw.oxm.exception.OXMappingException&quot;&gt;
 *                          &lt;value&gt;oxmException,8004C028&lt;/value&gt;
 *                      &lt;/entry&gt;
 *                                      E
 *                                      E
 *                                      E
 *                  &lt;/map&gt;
 *              &lt;/property&gt;
 *          &lt;/bean&gt;
 * </pre></code>
 * </p>
 * 
 * @see jp.terasoluna.fw.web.rich.springmvc.bind.creator.XMLServletRequestDataBinderCreator
 * @see jp.terasoluna.fw.oxm.xsd.message.ErrorMessage
 * @see jp.terasoluna.fw.oxm.xsd.message.ErrorMessages
 * @see jp.terasoluna.fw.oxm.exception.OXMappingException
 * @see jp.terasoluna.fw.oxm.xsd.SchemaValidator
 * @see jp.terasoluna.fw.oxm.mapper.OXMapper
 * @see org.springframework.web.servlet.handler.SimpleMappingExceptionResolver
 */
public class XMLServletRequestDataBinder extends ServletRequestDataBinder {
    
    /**
     * ONXB
     */
    private static Log log = LogFactory
            .getLog(XMLServletRequestDataBinder.class);

    /**
     * OXMapperB
     */
    private OXMapper oxmapper = null;

    /**
     * SchemaValidatorB
     */
    private SchemaValidator schemaValidator = null;

    /**
     * XMLServletRequestDataBinder𐶐B
     * 
     * @param target R}hIuWFNg
     * @param oxmapper OXMapper
     * @param schemaValidator SchemaValidator
     * @param objectName IuWFNg
     */
    public XMLServletRequestDataBinder(Object target, OXMapper oxmapper,
            SchemaValidator schemaValidator,String objectName) {
        super(target, objectName);
        this.oxmapper = oxmapper;
        this.schemaValidator = schemaValidator;
    }
    
    /**
     * XML`Œ`ꂽNGXgf[^oChB
     * <p>
     * ۂ̃f[^oCh́AOXMapperɏϏB
     * </p>
     * <p>
     * SchemaValidatorDIĂꍇA``FbNsB
     * </p>
     * 
     * @param request XML`Œ`ꂽNGXgf[^
     */
    @Override
    public void bind(ServletRequest request) {

        // XML`Œ`ꂽNGXgf[^̓̓Xg[擾
        InputStream in = null;

        try {
            in = request.getInputStream();

            // SchemaValidatorDIĂꍇA``FbNsB
            if (schemaValidator != null) {

                Document doc = validate(in);

                // ``FbNŃG[ꍇA𒆎~
                if (getBindingResult().hasErrors()) {
                    return;
                }
                // ``FbNς݂DOMc[gpāAA}[Vs
                oxmapper.unmarshal(doc, getTarget());
            } else {
                oxmapper.unmarshal(in, request.getCharacterEncoding(),
                        getTarget());
            }
        } catch (IOException e) {
            // Xg[擾̍ۂɁAo͗Oꍇ
            log.error("Request stream error.", e);
            throw new XMLRequestIOException(e);
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                log.error("Failed to close request stream.", e);
            }
        }

    }

    /**
     * NGXgf[^̌``FbNsB
     * <p>
     * ۂ̌``FbŃASchemaValidatorɏϏB
     * </p>
     * <p>
     * ``FbNG[ꍇA BindExceptionɃG[i[B
     * </p>
     * 
     * @param in XMLf[^
     * @return Document DOMc[
     */
    protected Document validate(InputStream in) {

        if (in == null) {
            log.error("InputStream is null.");
            throw new IllegalArgumentException("InputStream is null.");
        }
        
        // XL[}`ɂ``FbN
        ErrorMessages errorMessages = new ErrorMessages();

        Document doc = schemaValidator.validate(in, getTarget(), errorMessages);

        BindingResult errors = this.getBindingResult();

        // G[bZ[WꍇABindingResultɃG[lߑւ
        for (ErrorMessage errorMessage : errorMessages.getErrorMessages()) {
            
            // BindingResultɊi[邽߂̃G[𐶐
            FieldError fe = new FieldError(getObjectName(), errorMessage
                    .getField(), null, false, errors.resolveMessageCodes(
                    errorMessage.getKey(), errorMessage.getField()),
                    createReplaceValues(errorMessage.getField(), errorMessage
                            .getReplaceValues()), null);
            
            // BindingResultɃG[Zbg
            errors.addError(fe);
        }

        return doc;

    }

    /**
     * u𐶐B
     * <p>
     * u̍ŏɃtB[hǉAŌɃG[li[B
     * </p>
     * 
     * @param field tB[hl
     * @param replaceValues u
     * @return ẑOԖڂɃtB[h񂪕tꂽu
     */
    protected String[] createReplaceValues(
            String field, String[] replaceValues) {

        // tB[hlnull̏ꍇ͋󕶎ɕϊ
        if (field == null) {
            field = "";
        }

        // unull܂͋̃Xg̏ꍇA
        // tB[hl݂̂i[uԋp
        if (replaceValues == null || replaceValues.length == 0) {
            return new String[] { field };
        }

        String[] resultReplaceValues = new String[replaceValues.length + 1];

        // z̃Rs[
        System.arraycopy(replaceValues, 0, resultReplaceValues, 0,
                replaceValues.length);

        // tB[h͒u̍ŏɊi[
        resultReplaceValues[0] = field;

        // G[l͒u̍ŌɊi[
        resultReplaceValues[resultReplaceValues.length - 1] = replaceValues[0];

        return resultReplaceValues;
    }
}
