/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.context.support;

import jp.terasoluna.fw.web.rich.context.RequestContext;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ߂̕⏕WbÑftHgNXB<br>
 * OFHTTPNGXgNulllɂȂȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.context.support.DefaultRequestContextSupportImpl
 */
public class DefaultRequestContextSupportImplTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DefaultRequestContextSupportImplTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DefaultRequestContextSupportImplTest(String name) {
        super(name);
    }

    /**
     * testSetRequestNameHeaderKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() requestName:"command"<br>
     *         () this.requestNameHeaderKey:"requestName"<br>
     *         
     * <br>
     * ҒlF(ԕω) this.requestNameHeaderKey:"command"<br>
     *         
     * <br>
     * NGXgێ郊NGXgwb_ݒ肷鑮setter\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetRequestNameHeaderKey01() throws Exception {
        // eXg{
        DefaultRequestContextSupportImpl target = new DefaultRequestContextSupportImpl();
        target.setRequestNameHeaderKey("command");

        // 
        assertEquals("command", UTUtil.getPrivateField(target, "requestNameHeaderKey"));
    }

    /**
     * testDoGenerateContext01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() request:NGXgwb_<br>
     *                requestName=sum<br>
     *         () this.requestName:"requestName"<br>
     *         
     * <br>
     * ҒlF(߂l) RequestContext:RequestContexto<br>
     *                  @requestName="sum"<br>
     *                  p<br>
     *         (ԕω) getBLogicContext().getPropertyString():\bhĂяoꂽƂmFB<br>
     *         
     * <br>
     * NGXgReLXg𐶐郁\bhB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoGenerateContext01() throws Exception {
        // O
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setHeader("requestName", "sum");
        
        // eXg{
        DefaultRequestContextSupportImpl target = new DefaultRequestContextSupportImpl();
        RequestContext result = target.doGenerateContext(request);

        // 
        assertEquals("sum", result.getRequestName());
    }

}
