/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.terasoluna.fw.util.ExceptionUtil;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.form.ActionFormUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.springframework.web.struts.DelegatingRequestProcessor;

public class RequestProcessorEx
extends DelegatingRequestProcessor {
    private static Log log = LogFactory.getLog(RequestProcessorEx.class);
    public static final String SKIP_POPULATE = "SKIP_POPULATE";

    public void process(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"process() called.");
        }
        try {
            super.process(req, res);
        }
        catch (IOException e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error((Object)("sessionHash = " + sessionHash));
            log.error((Object)ExceptionUtil.getStackTrace(e));
            throw e;
        }
        catch (ServletException e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error((Object)("sessionHash = " + sessionHash));
            log.error((Object)ExceptionUtil.getStackTrace(e));
            throw e;
        }
        catch (Exception e) {
            String sessionHash = RequestUtil.getSessionHash(req);
            log.error((Object)("sessionHash = " + sessionHash));
            log.error((Object)ExceptionUtil.getStackTrace(e));
            throw new ServletException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"process() finished.");
        }
    }

    protected ActionForm processActionForm(HttpServletRequest req, HttpServletResponse res, ActionMapping mapping) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processActionForm() called. path = " + mapping.getPath()));
            log.debug((Object)("mapping.name = " + mapping.getName()));
            log.debug((Object)("mapping.scope = " + mapping.getScope()));
        }
        if (mapping instanceof ActionMappingEx && mapping.getScope() != null && "session".equals(mapping.getScope()) && mapping.getName() != null && mapping.getName().startsWith("_")) {
            return this.processActionFormEx(req, res, (ActionMappingEx)mapping);
        }
        return super.processActionForm(req, res, mapping);
    }

    protected ActionForm processActionFormEx(HttpServletRequest req, HttpServletResponse res, ActionMappingEx mapping) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processActionFormEx() called. path = " + mapping.getPath()));
        }
        boolean clearForm = false;
        clearForm = mapping.getClearForm();
        if (log.isDebugEnabled()) {
            log.debug((Object)("clearForm = " + clearForm));
        }
        if (clearForm) {
            HttpSession session = req.getSession();
            ActionFormUtil.clearActionForm(session);
        } else {
            HttpSession session = req.getSession();
            ActionFormUtil.clearActionForm(session, mapping.getName());
        }
        return super.processActionForm(req, res, (ActionMapping)mapping);
    }

    protected void processPopulate(HttpServletRequest req, HttpServletResponse res, ActionForm form, ActionMapping mapping) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processPopulate() called. path = " + mapping.getPath()));
        }
        boolean cancelPopulateflg = false;
        cancelPopulateflg = ((ActionMappingEx)mapping).getCancelPopulate();
        if (cancelPopulateflg) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"processPopulate() canceled.");
            }
            return;
        }
        String skipPopulate = (String)req.getAttribute(SKIP_POPULATE);
        if (skipPopulate != null) {
            if (skipPopulate.equals(mapping.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"processPopulate() skipped.");
                }
                return;
            }
            req.removeAttribute(SKIP_POPULATE);
        }
        super.processPopulate(req, res, form, mapping);
    }
}

