/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.upload.web.action;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.Globals;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;

import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.thin.functionsample.upload.bean.TupdownloadVO;
import jp.terasoluna.thin.functionsample.upload.service.InsertDBUpLoadService;
import jp.terasoluna.fw.util.PropertyUtil;

/**
 * t@CAbv[hANV
 * 
 */
public class UpLoadAction extends AbstractBLogicAction<TupdownloadVO> {

    /**
     * T[oŃAbv[ht@CۑpXB
     */
    protected static final String FILE_UPLOAD_PATH = "upload.00001.path";

    /**
     * HTTPNGXgTCYB
     */
    protected static final String REQEST_MAX_SIZE = "upload.00002.maxsizerequest";

    /**
     * Abv[ht@CTCYB
     */
    protected static final String FILE_MAX_SIZE = "upload.00003.maxsizefile";

    /**
     * G[bZ[WB t@CAbv[h@\ŕϐf[^̓vpeBt@C擾ɃG[܂B<br>
     */
    protected static final String FILE_UPLOAD_ERROR_MSG01 = "info.UC37.00001";

    /**
     * G[bZ[WB<br>
     * HTTPNGXgTCY͂̏𒴉߂B<br>
     */
    protected static final String FILE_UPLOAD_ERROR_MSG02 = "info.UC37.00002";

    /**
     * G[bZ[WB<br>
     * Abv[ht@C{0}̃TCY͏𒴉߂B<br>
     */
    protected static final String FILE_UPLOAD_ERROR_MSG03 = "info.UC37.00003";

    /**
     * G[bZ[WB<br>
     * t@CAbv[hs܂B<br>
     */
    protected static final String FILE_UPLOAD_ERROR_MSG04 = "info.UC37.00004";

    // caɃt@CAbv[ho^@\̃C^tF[X
    protected InsertDBUpLoadService insertDBUpLoadService = null;

    private String sizeOver = "success";

    private String overFileName = "";

    /**
     * <p>
     * t@CAbv[hANV
     * </p>
     * 
     * @param mapping
     *            ANV}bsO
     * @param form
     *            ANVtH[
     * @param request
     *            HTTPNGXg
     * @param response
     *            HTTPX|X
     * @return Jڐ̘_tH[hB <code>success</code>
     */

    @Override
    protected void preDoExecuteBLogic(HttpServletRequest request,
            HttpServletResponse response, TupdownloadVO tupdownloadVO)
            throws Exception {

        // t@CAbv[htO
        boolean upLoadFlag = false;
        // T[oŃAbv[ht@CۑpX
        String filePath = (String) PropertyUtil.getProperty(FILE_UPLOAD_PATH);
        // HTTPNGXgTCY擾
        String maxSizeRequestStr = (String) PropertyUtil
                .getProperty(REQEST_MAX_SIZE);
        // Abv[ht@CTCY擾
        String maxSizeFileStr = (String) PropertyUtil
                .getProperty(FILE_MAX_SIZE);
        // vpeBt@CŕϐȂ̏ꍇAI
        if (filePath == null || "".equals(filePath)
                || maxSizeRequestStr == null || "".equals(maxSizeRequestStr)
                || maxSizeFileStr == null || "".equals(maxSizeFileStr)) {
            // t@CAbv[h@\ŕϐf[^̓vpeBt@C
            // 擾ɃG[܂B
            sizeOver = "";
            // response.getStatus();
            return;
        } else {
            // pX݃`FbNA݂ȂꍇÃpX
            pathCheck(filePath);
        }

        // Abv[ht@CTCY擾
        int maxSizeFile = Integer.parseInt(maxSizeFileStr);

        // Strutsݒt@C̎w肷΁AHTTPNGXgTCY͂̏𒴉߂鎞A
        // org.apache.struts.upload.CommonsMultipartRequestHandler.javaŕϐZbg
        // request.setAttribute(
        // MultipartRequestHandler.ATTRIBUTE_MAX_LENGTH_EXCEEDED,
        // Boolean.TRUE);
        Object maxLengthExceededBl = request
                .getAttribute(MultipartRequestHandler.ATTRIBUTE_MAX_LENGTH_EXCEEDED);
        // ̕ϐ΁AHTTPNGXgTCY͂̏𒴉߂
        if (maxLengthExceededBl != null) {
            sizeOver = REQEST_MAX_SIZE;
            return;
        }

        // t@CTCY`FbN
        // Abv[ht@C̎擾
        FormFile fileup = tupdownloadVO.getFileup();
        if (fileup != null) {
            String fileName = fileup.getFileName();
            int fileSize = fileup.getFileSize();
            if (fileName != null && !"".equals(fileName)) {
                if (fileSize < 0 || fileSize > maxSizeFile) {
                    sizeOver = FILE_MAX_SIZE;
                    overFileName = fileName;
                    fileup.destroy();
                    return;
                }
            }
        }
        for (int i = 0; i < 3; i++) {
            // Abv[ht@C̎擾
            FormFile fileList = tupdownloadVO.getIndexFile(i);
            // Ytt@C󔒂łȂꍇ
            if (fileList != null) {
                // t@C擾
                String fileNameList = fileList.getFileName();
                // t@CTCY擾
                int fileSizeList = fileList.getFileSize();
                if (fileNameList != null && !"".equals(fileNameList)) {
                    if (fileSizeList < 0 || fileSizeList > maxSizeFile) {
                        // erro
                        sizeOver = FILE_MAX_SIZE;
                        overFileName = fileNameList;
                        fileList.destroy();
                        return;
                    }
                }
            }
            fileList.destroy();
        }

        // Pt@CAbv[h@\
        // Ytt@C󔒂łȂꍇ
        if (fileup != null) {
            // t@C擾
            String fileName = fileup.getFileName();
            // t@CTCY擾
            int fileSize = fileup.getFileSize();
            if (fileName != null && !"".equals(fileName)) {
                if (0 <= fileSize && fileSize <= maxSizeFile) {
                    // getInputStream\bhgpA̓Xg[擾
                    InputStream is = fileup.getInputStream();
                    // ̓Xg[obt@O
                    BufferedInputStream inBuffer = new BufferedInputStream(is);
                    // t@C̃Abv[hw肵āAo̓Xg[𐶐
                    FileOutputStream fos = new FileOutputStream(filePath + "/"
                        	+ fileup.getFileName());
                    // o̓Xg[obt@O
                    BufferedOutputStream outBuffer = new BufferedOutputStream(
                        	fos);
                    // ̓f[^ȂȂ܂œo͏s
                    int data = 0;
                    while ((data = inBuffer.read()) != -1) {
                        outBuffer.write(data);
                    }

                    // 
                    outBuffer.flush();
                    inBuffer.close();
                    outBuffer.close();
                    // ꎞ̈̃Abv[hf[^폜
                    fileup.destroy();
                    upLoadFlag = true;
                    tupdownloadVO.setFileName(fileName);
                    tupdownloadVO.setFilePath(filePath);
                    String fileSizeStr = sizeToString(fileSize);
                    tupdownloadVO.setFileSize(fileSizeStr);
                }
            }

        }

        // t@CAbv[h@\
        // ƃpX
        String[] listFileName = new String[3];
        String[] listFilePath = new String[3];
        String[] listFileSize = new String[3];
        // 
        int j = 0;
        for (int i = 0; i < 3; i++) {
            // Abv[ht@C̎擾
            FormFile fileList = tupdownloadVO.getIndexFile(i);
            // Ytt@C󔒂łȂꍇ
            if (fileList != null) {
                // t@C擾
                String fileNameList = fileList.getFileName();
                // t@CTCY擾
                int fileSizeList = fileList.getFileSize();
                if (fileNameList != null && !"".equals(fileNameList)) {
                    if (0 <= fileSizeList && fileSizeList <= maxSizeFile) {
                        InputStream streamList = fileList.getInputStream();// t@Cǂݍ
                        // Abv[ht@C linux̏ꍇUploadFiles"\\""/"
                        OutputStream bosList = new FileOutputStream(filePath
                        		+ "/" + fileList.getFileName());

                        request.setAttribute("fileName", filePath + "/"
                        		+ fileList.getFileName());
                        int bytesRead = 0;
                        byte[] buffer = new byte[8192];
                        // t@CAbv[h
                        while ((bytesRead = streamList.read(buffer, 0, 8192)) != -1) {
                        	bosList.write(buffer, 0, bytesRead);
                        }
                        // t@C𐮗
                        listFileName[j] = fileNameList;
                        // t@CTCY𐮗
                        listFileSize[j] = sizeToString(fileSizeList);
                        // t@CpX𐮗
                        listFilePath[j] = filePath;
                        j++;
                        // 
                        bosList.close();
                        streamList.close();
                        fileList.destroy();
                        upLoadFlag = true;
                    }
                }

            }
        }
        // t@CƃpXVOɃZbg
        tupdownloadVO.setListFileName(listFileName);
        tupdownloadVO.setListFileSize(listFileSize);
        tupdownloadVO.setListFilePath(listFilePath);
        if (upLoadFlag) {
            sizeOver = "success";
        } else {
            sizeOver = "false";
        }
    }

    /**
     * cat@CAbv[he[uɐVKt@CAbv[ho^B
     * 
     * @param tupdownloadVO
     *            caR[hXgo^@\Ŏgp[^NX
     * @return t@CAbv[h@\
     * @throws Exception
     */
    @Override
    public BLogicResult doExecuteBLogic(TupdownloadVO tupdownloadVO)
            throws Exception {
        // DBo^pVO
        TupdownloadVO tupdownloadVONew = new TupdownloadVO();
        // zt@C
        String[] listFileName = tupdownloadVO.getListFileName();
        // zt@CpX
        String[] listFilePath = tupdownloadVO.getListFilePath();
        String[] listFileSize = tupdownloadVO.getListFileSize();
        // BL Result
        BLogicResult result = new BLogicResult();
        // Pt@CAbv[h񏈗
        String fileName = tupdownloadVO.getFileName();
        String filePath = tupdownloadVO.getFilePath();
        String fileSize = tupdownloadVO.getFileSize();
        // e[uږfileID
        long fileID = System.currentTimeMillis();
        // Pt@CAbv[ho^
        if (fileName != null && !"".equals(fileName) && filePath != null
                && !"".equals(filePath) && fileSize != null
                && !"".equals(fileSize)) {
            tupdownloadVO.setFileId(Long.toString(fileID + 0));
            insertDBUpLoadService.insertDBUpLoad(tupdownloadVO);
        }
        // t@CAbv[ho^
        for (int i = 0; i < 3; i++) {
            tupdownloadVONew.setFileId(Long.toString(fileID + i + 1));
            tupdownloadVONew.setFileName(listFileName[i]);
            tupdownloadVONew.setFilePath(listFilePath[i]);
            tupdownloadVONew.setFileSize(listFileSize[i]);
            if (listFileName[i] != null && !"".equals(listFileName[i])
                    && listFilePath[i] != null && !"".equals(listFilePath[i])) {
                insertDBUpLoadService.insertDBUpLoad(tupdownloadVONew);
            }
        }

        // BL ResultZbg
        result.setResultObject(tupdownloadVO);
        if (sizeOver.equals("success")) {
            result.setResultString("success");
        } else {
            // G[bZ[W𐶐
            BLogicMessages errors = result.getErrors();
            if (errors == null) {
                errors = new BLogicMessages();
            }
            // vpeBt@CŕϐȂ
            if (sizeOver.equals("")) {
                errors.add(Globals.ERROR_KEY, new BLogicMessage(
                        FILE_UPLOAD_ERROR_MSG01));
                result.setErrors(errors);
            }
            // HTTPNGXgTCY͂̏𒴉߂
            if (sizeOver.equals(REQEST_MAX_SIZE)) {
                errors.add(Globals.ERROR_KEY, new BLogicMessage(
                        FILE_UPLOAD_ERROR_MSG02));
                result.setErrors(errors);
            }
            // Abv[ht@CTCY͏𒴉߂
            if (sizeOver.equals(FILE_MAX_SIZE)) {
                errors.add(Globals.ERROR_KEY, new BLogicMessage(
                        FILE_UPLOAD_ERROR_MSG03, overFileName));
                result.setErrors(errors);
            }
            // G[
            if (sizeOver.equals("false")) {
                errors.add(Globals.ERROR_KEY, new BLogicMessage(
                        FILE_UPLOAD_ERROR_MSG04));
                result.setErrors(errors);
            }
            result.setResultString("false");
        }
        return result;
    }

    /**
     * pX݃`FbN<br>
     * ݂ȂꍇÃpX<br>
     * 
     * @param path
     *            String pX
     * 
     * @return
     */
    private void pathCheck(String path) {
        File pfile = null;
        pfile = new File(path);
        if (!pfile.exists()) {
            pfile.mkdirs();
        }
    }

    /**
     * TCY\ɐ<br>
     * 1000000ȏ̏ꍇA**M<br>
     * 1000   ȏ̏ꍇA**K<br>
     * 
     * @param fileSize
     *            int
     * 
     * @return
     */
    private String sizeToString(int fileSize) {
        String fileSizeStr = "";
        if (fileSize / 1000000 > 0) {
            fileSizeStr = Integer.toString(fileSize / 1000000).concat("M");
        } else if (fileSize / 1000 > 0) {
            fileSizeStr = Integer.toString(fileSize / 1000).concat("K");
        } else {
            fileSizeStr = Integer.toString(fileSize);
        }
        return fileSizeStr;
    }

    /**
     * registDBUpLoadService擾B
     * 
     * @return registDBUpLoadService
     */
    public InsertDBUpLoadService getInsertDBUpLoadService() {
        return insertDBUpLoadService;
    }

    /**
     * registDBUpLoadServiceݒ肷B
     * 
     * @param registDBUpLoadService
     *            registDBUpLoadServiceB
     */
    public void setInsertDBUpLoadService(
            InsertDBUpLoadService insertDBUpLoadService) {
        this.insertDBUpLoadService = insertDBUpLoadService;
    }

}
