/*
 * Copyright (c) 2009 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.database.bean;

import java.io.OutputStream;

/**
 * CSV_E[hpp[^C^tF[X
 * 
 */
public interface CsvDlAddressParam {
    /**
     * NGXgwb_擾
     * @param name
     * @return
     */
    String getHeader(String name);

    /**
     * X|X̕GR[fBOݒ
     * @param charset
     */
    void setCharacterEncoding(java.lang.String charset);

    /**
     * Reg^Cvݒ
     * @param type
     */
    void setContentType(String type);

    /**
     * bZ[W{fB̒ݒ
     * @param len
     */
    void setContentLength(int len);

    /**
     * wb_ǉ
     * @param name
     * @param value
     */
    void addHeader(String name, String value);

    /**
     * OutputStream擾
     * @return
     */
    OutputStream getOutputStream();
}
