/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.blockage.web;

import java.util.HashSet;
import java.util.List;

import javax.servlet.ServletRequest;

import jp.terasoluna.fw.web.RequestUtil;

/**
 * @\ԗTvAP̋ƖǃRg[
 *
 */
public class BlockageController implements
        jp.terasoluna.fw.web.thin.BlockageController {
    /**
     * `FbNȂpX
     */
    private List<String> noCheckPath = null;
    
    /**
     * ƖǂĂpX
     */
    private HashSet<String> blockadedPaths = new HashSet<String>();
    
    /**
     * ZbVgȂ߁AI[o[[hꂽ\bhɈϏ
     *
     * @param path
     */
    public void blockade(String path) {
        blockade(path, null);
    }

    /**
     * w肳ꂽAƖĂяopXǂ
     *
     * @param path
     * @param req
     */
    public void blockade(String path, ServletRequest req) {
        synchronized (blockadedPaths){
            blockadedPaths.add(path);
        }
    }

    /**
     * ZbVgȂ߁AI[o[[hꂽ\bhɈϏ
     *
     * @param path
     * @return
     */
    public boolean isBlockaded(String path) {
        return isBlockaded(path, null);
    }

    /**
     * ƖǏԂ̏ꍇtrueԂAłȂꍇAfalseԂ
     *
     * @param path
     * @param req
     * @return
     */
    public boolean isBlockaded(String path, ServletRequest req) {
        synchronized (blockadedPaths) {
            if (blockadedPaths.contains(path)) {
                return true;
            }
            return false;
        }
    }

    /**
     * Ɩǃ`FbNKvǂ肵AKvȂtrue,KvȂȂfalseԂ
     *
     * @param req
     * @return
     */
    public boolean isCheckRequired(ServletRequest req) {
        for (String path : noCheckPath) {
            if ((RequestUtil.getPathInfo(req)).equals(path)){
                return false;
            }
        }
        return true;
    }

    /**
     * ZbVgȂ߁AI[o[[hꂽ\bhɈϏ
     *
     * @param path
     */
    public void open(String path) {
        open(path, null);

    }

    /**
     * w肳ꂽAƖĂяopXJ
     *
     * @param path
     * @param req
     */
    public void open(String path, ServletRequest req) {
        synchronized (blockadedPaths) {
            blockadedPaths.remove(path);
        }
    }

    /**
     * noCheckPath擾B
     * @return noCheckPath
     */
    public List<String> getNoCheckPath() {
        return noCheckPath;
    }

    /**
     * noCheckPathݒ肷B
     * @param noCheckPath noCheckPathB
     */
    public void setNoCheckPath(List<String> noCheckPath) {
        this.noCheckPath = noCheckPath;
    }
}