/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.taglib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import jp.terasoluna.fw.web.taglib.TagUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StringFormatterTagBase
extends TagSupport {
    private static Log log = LogFactory.getLog(StringFormatterTagBase.class);
    protected String id = null;
    protected boolean filter = true;
    protected boolean ignore = false;
    protected String name = null;
    protected String property = null;
    protected String scope = null;
    protected String value = null;
    protected boolean replaceSpToNbsp = true;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean getIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getReplaceSpToNbsp() {
        return this.replaceSpToNbsp;
    }

    public void setReplaceSpToNbsp(boolean replaceSpToNbsp) {
        this.replaceSpToNbsp = replaceSpToNbsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doStartTag() throws JspException {
        Object value = this.value;
        if (value == null) {
            if (this.ignore && TagUtil.lookup(this.pageContext, this.name, this.scope) == null) {
                return 0;
            }
            value = TagUtil.lookup(this.pageContext, this.name, this.property, this.scope);
            if (value == null) {
                return 0;
            }
        }
        String output = this.doFormat(value.toString());
        if (this.id != null) {
            this.pageContext.setAttribute(this.id, (Object)output);
        } else {
            if (this.filter) {
                output = TagUtil.filter(output);
            }
            StringReader sr = null;
            BufferedReader br = null;
            String line = null;
            try {
                sr = new StringReader(output);
                br = new BufferedReader(sr);
                StringBuilder sbuf = new StringBuilder();
                StringBuilder strBuf = new StringBuilder();
                int index = 0;
                while ((line = br.readLine()) != null) {
                    if (this.replaceSpToNbsp && !"".equals(line)) {
                        strBuf.setLength(0);
                        char ch = line.charAt(0);
                        int i = 0;
                        for (i = 0; i < line.length(); ++i) {
                            ch = line.charAt(i);
                            if (ch == ' ') {
                                strBuf.append("&nbsp;");
                                continue;
                            }
                            strBuf.append(ch);
                        }
                        line = strBuf.toString();
                    }
                    sbuf.append(line);
                    ++index;
                }
                output = sbuf.toString();
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("StringReader IO error : " + e));
                }
            }
            finally {
                block25: {
                    if (sr != null) {
                        sr.close();
                    }
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e1) {
                        if (!log.isWarnEnabled()) break block25;
                        log.warn((Object)("StringReader close error : " + e1));
                    }
                }
            }
            TagUtil.write(this.pageContext, output);
        }
        return 0;
    }

    public void release() {
        super.release();
        this.id = null;
        this.filter = true;
        this.ignore = false;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.value = null;
        this.replaceSpToNbsp = true;
    }

    protected abstract String doFormat(String var1);
}

