﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;
using System.IO;
using System.Web;
using CalcWcfBusinessApplication.Dto;
using CalcWcfBusinessApplication.Properties;
using Microsoft.Practices.EnterpriseLibrary.Validation.Integration.WCF;


namespace CalcWcfBusinessApplication.Service
{
    // メモ: ここでクラス名 "MtomStreamedService" を変更する場合は、App.config で "MtomStreamedService" への参照も更新する必要があります。
    /// <summary>
    /// MTOMストリーミング転送モードを使ったファイルアップロード、ダウンロードのサンプル
    /// </summary>
    [ServiceContract]
    public class MtomStreamedService
    {
        /// <summary>
        /// ダウンロードファイル名
        /// </summary>
        private static readonly string DOWNLOAD_FILENAME_PATH =
            HttpRuntime.AppDomainAppPath + "File\\";

        /// <summary>
        /// ストリームを読み込むときのバッファサイズ
        /// </summary>
        private const int BUFFER_SIZE = 1024;

        #region IMtomStreamedService メンバ

        /// <summary>
        /// ファイルをアップロードする
        /// </summary>
        /// <param name="transferdFile"></param>
        [OperationContract]
        public void Upload(TransferedFileByStream transferdFile)
        {
            using (Stream stream = transferdFile.FileData)
            {
                using (FileStream outputFile = File.Create(Path.GetTempPath() + "Uploaded_" + transferdFile.FileName))
                {
                    byte[] buf = new byte[BUFFER_SIZE];
                    int len = 0;
                    while ((len = stream.Read(buf, 0, buf.Length)) != 0)
                    {
                        outputFile.Write(buf, 0, len);
                    }
                }
            }
        }

        /// <summary>
        /// ファイルをダウンロードする
        /// </summary>
        /// <param name="inputDto"></param>
        /// <returns></returns>
        [OperationContract]
        ///サーバ側入力値検証の設定
        [ValidationBehavior(RuleSet = "RS01")]
        public TransferedFileByStream Download(DownloadInputDto2 inputDto)
        {
            string filePath = DOWNLOAD_FILENAME_PATH + inputDto.FileName;
            TransferedFileByStream downloadFile = new TransferedFileByStream();
            if (File.Exists(filePath))
            {
                FileStream stream = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                downloadFile.FileName = inputDto.FileName;
                downloadFile.FileData = stream;
                downloadFile.Length = stream.Length;
            }
            else
            {
                throw new FileNotFoundException(string.Format(Resources.ERROR_MTOM_MSG001, filePath));
            }
            return downloadFile;
        }

        #endregion
    }
}
