﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using CalcWcfBusinessApplication.Properties;


namespace CalcWcfBusinessApplication.Dto
{
    /// <summary>
    /// 計算処理の入力DTO
    /// </summary>
    [DataContract]
    [HasSelfValidation]
    public class CalcInputDto
    {
        [DataMember]
        [IntRangeValidator(LowerBound = 0, LowerBoundType = RangeBoundaryType.Inclusive,
                           UpperBound = 100, UpperBoundType = RangeBoundaryType.Inclusive,
                           Tag = "数値1", Ruleset = "RS01")]
        public int Num1 { get; set; }

        [DataMember]
        [IntRangeValidator(LowerBound = 0, LowerBoundType = RangeBoundaryType.Inclusive,
                           UpperBound = 100, UpperBoundType = RangeBoundaryType.Inclusive,
                           Tag = "数値2", Ruleset = "RS01")]
        public int Num2 { get; set; }


        /// <summary>
        /// カスタム入力チェックの例
        /// </summary>
        [SelfValidation(Ruleset ="RS01")]
        private void CustomValidate01(ValidationResults results)
        {
            ///カスタム入力チェックの実装方法理解のため無理やり入力チェック
            ///数値１と数値２が同じ数だとエラーになる
            if (Num1 == Num2)
            {
                ValidationResult result =
                    new ValidationResult(Resources.ERROR_CALC_MSG001, this, string.Empty, string.Empty, null);
                results.AddResult(result);
            }
        }
    }
}
