﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.DataCopy;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;

// ViewDataクラスを作成後、正しい名前空間を指定しコメント化を解除して下さい。
using CalcBusinessApplication.ViewData;
using CalcBusinessApplication.Properties;

namespace CalcBusinessApplication.View
{
    // ScreenIdが決定後、指定して下さい。
    [ScreenId("FileUploadView")]
    public partial class FileUploadView : Form
    {
        // ViewDataクラスを作成後、コメント化を解除して下さい。
        public FileUploadViewData ViewData { get; set; }

        public FileUploadView()
        {
            InitializeComponent();
            // ViewDataクラスを作成後、コメント化を解除して下さい。
            ViewData = ValidatableViewDataManager.CreateViewData<FileUploadViewData>();
        }

        private void FileUploadView_Load(object sender, EventArgs e)
        {
            // バインディングソース名が確定したら、修正後コメント化を解除して下さい。
            fileUploadViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 参照ボタン押下時
        /// </summary>
        private void referButton_Click(object sender, EventArgs e)
        {
            DialogResult result = openFileDialog1.ShowDialog(this);
            if (result == DialogResult.OK)
            {
                ViewData.FileName = openFileDialog1.FileName;
            }
        }

        /// <summary>
        /// アップロード(Stream)ボタン押下時
        /// </summary>
        private void uploadByStreamButton_Click(object sender, EventArgs e)
        {
            uploadByStreamEventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// アップロード(byte[])ボタン押下時
        /// </summary>
        private void uploadByByteArrayButton_Click(object sender, EventArgs e)
        {
            uploadByByteArrayEventProcessWorker.RunWorkerAsync();
        }

        /// <summary>
        /// イベント処理完了時
        /// </summary>        
        private void eventProcessWorker_Completed(object sender, Terasoluna.Windows.Forms.Events.EventProcCompletedEventArgs e)
        {
            if (e.Result.IsSuccess)
            {
                MessageNotifier.ShowInformationMessage(this, Resources.INFO_MTOM_MSG001);
            }
        }
    }
}
