﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.DataCopy;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.Windows.Forms.MessageNotification;
using Terasoluna.Windows.ViewModel;

// ViewDataクラスを作成後、正しい名前空間を指定しコメント化を解除して下さい。
using CalcBusinessApplication.ViewData;

namespace CalcBusinessApplication.View
{
    // ScreenIdが決定後、指定して下さい。
    [ScreenId("CalcView")]
    public partial class CalcView : Form
    {
        // ViewDataクラスを作成後、コメント化を解除して下さい。
        public CalcViewData ViewData { get; set; }

        public CalcView()
        {
            InitializeComponent();
            // ViewDataクラスを作成後、コメント化を解除して下さい。
            ViewData = ValidatableViewDataManager.CreateViewData<CalcViewData>();
        }

        private void CalcView_Load(object sender, EventArgs e)
        {
            // バインディングソース名が確定したら、修正後コメント化を解除して下さい。
            calcViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 計算ボタン押下時
        /// </summary>
        private void calcButton_Click(object sender, EventArgs e)
        {
            if (wcfRadioButton.Checked)
            {
                wcfEventProcessWorker.RunWorkerAsync();
            }
            else if (jaxWsRadioButton.Checked)
            {
                jaxWsEventProcessWorker.RunWorkerAsync();
            }
        }
    }
}
