﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.BizLogic;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.ExceptionHandling;
using CalcBusinessApplication.Dto;
using CalcBusinessApplication.Properties;

namespace CalcBusinessApplication.BizLogic
{
    /// <summary>
    /// ログイン処理
    /// クライアントでビジネスロジックを実行する例
    /// </summary>
    public class LoginBizLogic
    {
        /// <summary>
        /// ログインする
        /// </summary>
        /// <param name="input">ログイン情報</param>
        public void Login(LoginInputDto input)
        {
            ///簡単のため、ユーザID="terasoluna"、パスワード="passsword"であることをチェックする
            if (!"terasoluna".Equals(input.UserId, StringComparison.Ordinal)
                || !"password".Equals(input.Password, StringComparison.Ordinal))
            {
                ///業務エラーは、errorTypeをBizLogicExceptionErrorType.BizLogicFailureにして
                ///BizLogicExceptionをスローする
                throw new BizLogicException(
                    BizLogicExceptionErrorType.BizLogicFailure,
                    Resources.ERROR_CALC_MSG002,
                    new List<ErrorInfo>()
                    {
                        new ErrorInfo("ERROR_CALC_MSG003", null, Resources.ERROR_CALC_MSG003, null)
                    });
            }
        }
    }
}
