﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Practices.Unity;
using CalcBusinessApplication.Dto;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using CalcBussinessApplication.IO;
using System.IO;
using CalcBusinessApplication.MtomStreamedServiceReference;

namespace CalcBusinessApplication.BizLogic
{
    public class FileUploadByStreamBizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "BasicHttpBinding_MtomStreamedService";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="inputDto"></param>
        public void Upload(FileInfoDto inputDto)
        {
            ///エンドポイントアドレスの取得
            ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
            EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
            MtomStreamedServiceClient client = new MtomStreamedServiceClient(EndpointName, address);
            ///通常のStream
            //using (FileStream fs = new FileStream(inputDto.UploadFilePath, FileMode.Open))
            ///ファイル送信率を通知するStream
            using (NotifyProgressInfoFileStream fs =
                new NotifyProgressInfoFileStream(new FileStream(inputDto.FileName, FileMode.Open)))
            {
                try
                {
                    //ファイルアップロード
                    client.Upload(Path.GetFileName(inputDto.FileName), fs.Length, fs);
                    client.Close();
                }
                catch (System.Exception)
                {
                    if (client != null)
                    {
                        client.Abort();
                    }
                    throw;
                }
            }
        }
    }
}
