﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Practices.Unity;
using CalcBusinessApplication.Dto;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using CalcBussinessApplication.IO;
using System.IO;
using CalcBusinessApplication.MtomStreamedServiceReference;
using CalcBusinessApplication.MtomServiceReference;

namespace CalcBusinessApplication.BizLogic
{
    public class FileUploadBizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "WSHttpBinding_MtomService";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        /// ファイルをアップロードする
        /// </summary>
        /// <param name="inputDto">アップロードするファイル情報</param>
        public void Upload(FileInfoDto inputDto)
        {
            ///エンドポイントアドレスの取得
            ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
            EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
            MtomServiceClient client = new MtomServiceClient(EndpointName, address);
            ///通常のStream
            //using (FileStream fs = new FileStream(inputDto.UploadFilePath, FileMode.Open))
            ///ファイル送信率を通知するStream
            using (NotifyProgressInfoFileStream fs =
                new NotifyProgressInfoFileStream(new FileStream(inputDto.FileName, FileMode.Open)))
            {
                try
                {                    
                    byte[] uploadData = new byte[fs.Length];
                    fs.Read(uploadData, 0, (int)fs.Length);
                    //ファイルアップロード                    
                    client.Upload(new TransferedFile()
                    {
                        FileName = Path.GetFileName(inputDto.FileName),
                        FileData = uploadData
                    });
                    client.Close();
                }
                catch (System.Exception)
                {
                    if (client != null)
                    {
                        client.Abort();
                    }
                    throw;
                }
            }
        }
    }
}
