﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace CalcWcfBusinessApplication.Dto
{
    /// <summary>
    /// ファイルアップロード・ダウンロードに使用するファイルオブジェクト
    /// MessageContractを使ってファイルヘッダーに長さやファイル名を格納できる
    /// ファイルデータはStream型なのでストリーミング転送モードで利用可能
    /// </summary>
    [MessageContract]
    public class TransferedFileByStream : IDisposable
    {
        /// <summary>
        /// ファイル名
        /// </summary>
        [MessageHeader]
        public string FileName { get; set; }

        /// <summary>
        /// ファイルのサイズ
        /// </summary>
        [MessageHeader]
        public long Length { get; set; }

        /// <summary>
        /// ファイルのストリーミングデータ
        /// </summary>
        [MessageBodyMember]
        public System.IO.Stream FileData { get; set; }

        /// <summary>
        /// Dispose時にファイルをクローズ
        /// </summary>
        public void Dispose()
        {
            if (FileData != null)
            {
                FileData.Close();
                FileData = null;
            }
        }

    }
}
