﻿    using CalcWcfBusinessApplication.Service;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using CalcWcfBusinessApplication.Dto;
using System;
using Terasoluna.BizLogic;
using Terasoluna;

namespace CalcWcfBusinessApplication.UT
{
  
    /// <summary>
    ///CalcServiceTest のテスト クラスです。すべての
    ///CalcServiceTest 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    [DeploymentItem("TerasolunaBootstrap.config")]
    [DeploymentItem("TerasolunaFramework.config")]
    [DeploymentItem("TerasolunaApplication.config")]
    [DeploymentItem("CalcWcfBusinessApplication.config")]
    [DeploymentItem("CalcDBForSql2008.mdf")]  
    public class CalcServiceTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            TerasolunaFramework.Run();
        }
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        [ClassCleanup()]
        public static void MyClassCleanup()
        {
            TerasolunaFramework.Exit();
        }
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///Login のテストの例
        ///UserIDとPasswordが正しい場合にログインに成功すること
        ///</summary>
        [TestMethod()]
        public void LoginTest01()
        {
            string userId = "terasoluna";
            string password = "password";
            CalcService target = new CalcService();
            LoginInputDto inputDto = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(inputDto);                
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }            
        }


        /// <summary>
        ///Login のテストの例
        ///UserIDが異なる場合に業務エラー(ERROR_CALC_MSG003)になること
        ///</summary>
        [TestMethod()]
        public void LoginTest02()
        {
            string userId = "hoge";
            string password = "password";
            CalcService target = new CalcService();
            LoginInputDto input = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(input);
                Assert.Fail("入力チェックエラーが発生しませんでした");
            }
            catch (BizLogicException e)
            {
                Assert.AreEqual("BizLogicFailure", e.ErrorType);
                Assert.AreEqual(1, e.Errors.Count);
                Assert.AreEqual("ERROR_CALC_MSG003", e.Errors[0].ErrorId);
                Assert.AreEqual("ユーザIDまたはパスワードに誤りがあります。", e.Errors[0].Message);
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }
        }


        /// <summary>
        ///Login のテストの例
        ///Passwordが異なる場合に業務エラー(ERROR_CALC_MSG003)になること
        ///</summary>
        [TestMethod()]
        public void LoginTest03()
        {
            string userId = "terasoluna";
            string password = "hoge";
            CalcService target = new CalcService();
            LoginInputDto input = new LoginInputDto() { UserId = userId, Password = password };
            try
            {
                target.Login(input);
                Assert.Fail("入力チェックエラーが発生しませんでした");
            }
            catch (BizLogicException e)
            {
                Assert.AreEqual("BizLogicFailure", e.ErrorType);
                Assert.AreEqual(1, e.Errors.Count);
                Assert.AreEqual("ERROR_CALC_MSG003", e.Errors[0].ErrorId);
                Assert.AreEqual("ユーザIDまたはパスワードに誤りがあります。", e.Errors[0].Message);
            }
            catch (Exception e)
            {
                Assert.Fail(e.Message);
            }
        }

        /// <summary>
        ///Add のテストの例
        /// 1 + 2 = 3であること
        ///</summary>
        [TestMethod()]
        public void AddTest()
        {
            int num1 = 1;
            int num2 = 2;
            int answer = 3;
            CalcService target = new CalcService();
            CalcInputDto inputDto = new CalcInputDto() { Num1 = num1, Num2 = num2 };
            CalcOutputDto expected = new CalcOutputDto { Answer = answer };
            CalcOutputDto actual;
            actual = target.Add(inputDto);
            Assert.AreEqual(expected.Answer, actual.Answer);            
        }

    }
}
