﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Terasoluna.Windows.ViewModel.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using CalcBusinessApplication.Properties;

namespace CalcBusinessApplication.ViewData
{
    /// <summary>
    /// 計算画面の画面データクラス
    /// </summary>
    [HasSelfValidation]
    [DefaultRuleset("RS01")]
    // [RulesetMapping("RS01", "", "")]
    public class CalcViewData : ValidatableRootViewData
    {
        [DisplayName("数値1")]
        [RequiredValidator(Tag="数値1", Ruleset="RS01")]
        [IntRangeValidator(LowerBound = 0, LowerBoundType = RangeBoundaryType.Inclusive,
        		  		   UpperBound = 100, UpperBoundType = RangeBoundaryType.Inclusive,
                           Tag="数値1", Ruleset="RS01")]
        public virtual string Num1 { get; set; }

        [DisplayName("数値2")]
        [RequiredValidator(Tag = "数値2", Ruleset = "RS01")]
        [IntRangeValidator(LowerBound = 0, LowerBoundType = RangeBoundaryType.Inclusive,
                   UpperBound = 100, UpperBoundType = RangeBoundaryType.Inclusive,
                   Tag = "数値2", Ruleset = "RS01")]
        public virtual string Num2 { get; set; }

        [DisplayName("答え")]
        public virtual string Answer { get; set; }
        
        [SelfValidation(Ruleset = "RS01")]
        private void CustomValidate01(ValidationResults results)
        {
            ///カスタム入力チェックの実装方法理解のため無理やり入力チェック
            ///数値１と数値２が同じ数だとエラーになる
            if (Num1.Equals(Num2, StringComparison.Ordinal))
            {
                ///相関チェックでもエラーを各コントロールに表示するなら
                ///keyにプロパティ名を指定してValidationResultを作成
                ValidationResult resultForNum1 =
                    new ValidationResult(Resources.ERROR_CALC_MSG001, this,
                        "Num1", null, EventSpecificValidator.DefaultInstance);
                ValidationResult resultForNum2 =
                    new ValidationResult(Resources.ERROR_CALC_MSG001, this,
                "Num2", null, EventSpecificValidator.DefaultInstance);
                results.AddResult(resultForNum1);
                results.AddResult(resultForNum2);
            }
        }
    }


}
