﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace CalcWinFormsApp.View
{
    /// <summary>
    /// ダウンロードするファイルを選択するラジオボタングループ
    /// 単純データバインド可能なプロパティを追加したカスタムコントロールの実装例
    /// </summary>
    [DefaultBindingProperty("SelectedValue")]
    public partial class FileTypeRadioButtonGroup : UserControl
    {
        /// <summary>
        /// ファイル名
        /// </summary>
        public const string TXT = "てらそるな.txt";
        public const string CSV = "てらそるな.csv";
        public const string PNG = "てらそるな.png";

        private string selectedValue = null;

        public FileTypeRadioButtonGroup()
        {
            InitializeComponent();
        }

        /// <summary>
        /// ProertyNameChangedパターンの実装
        /// </summary>
        public event EventHandler SelectedValueChanged;

        /// <summary>
        /// バインド対象のプロパティ
        /// </summary>
        [Bindable(true)]
        public string SelectedValue
        {
            get
            {
                return selectedValue;
            }
            set
            {
                if (!string.Equals(selectedValue, value, StringComparison.Ordinal))
                {
                    switch (value)
                    {
                        case TXT :
                            txtRadioButton.Checked = true;
                            break;
                        case CSV:
                            csvRadioButton.Checked = true;
                            break;
                        case PNG :
                            pngRadioButton.Checked = true;
                            break;
                        default:
                            break;
                    }
                    selectedValue = value;
                    OnSelectedValueChanged(EventArgs.Empty);
                }

            }
        }

        /// <summary>
        /// SelectedValueChangedイベントの発火
        /// </summary>
        /// <param name="e"></param>
        protected virtual void OnSelectedValueChanged(EventArgs e)
        {
            EventHandler handler = SelectedValueChanged;
            if (handler != null)
            {
                handler(this, e);

            }
        }
        
        /// <summary>
        /// 「テキストファイル」ラジオボタンチェック時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void txtRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (txtRadioButton.Checked)
            {
                this.selectedValue = TXT;
                OnSelectedValueChanged(EventArgs.Empty);
            }
        }
        /// <summary>
        /// 「CSVファイル」ラジオボタンチェック時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void csvRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (csvRadioButton.Checked)
            {
                this.selectedValue = CSV;
                OnSelectedValueChanged(EventArgs.Empty);
            }
        }
        /// <summary>
        /// 「画像ファイル」ラジオボタンチェック時
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pngRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (pngRadioButton.Checked)
            {
                this.selectedValue = PNG;
                OnSelectedValueChanged(EventArgs.Empty);
            }
        }
    }
}
