package jp.terasoluna.rich.tutorial.service.common.aop;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.rich.tutorial.service.common.exception.ApplicationException;
import jp.terasoluna.rich.tutorial.service.common.message.MessageAccessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ThrowsAdvice;

/**
 *
 * 例外がスローされたときに、プロパティファイルから
 * エラーコードをキーとしてメッセージを取得しセットするAOPのサンプル実装
 *
 */

public class SampleThrowAdvice implements ThrowsAdvice {
    private MessageAccessor messageAccessor;
    private static Log log = LogFactory.getLog(SampleThrowAdvice.class);

    public void setMessageAccessor(MessageAccessor messageAccessor) {
        this.messageAccessor = messageAccessor;
    }

    /**
     * 業務例外のハンドリング
     *
     * @param e
     * @throws Throwable
     */
    public void afterThrowing(ApplicationException e) throws Throwable {
        e.setMessage(messageAccessor.getMessage(e.getErrorCode(), e
                .getOptions()));
        if (log.isWarnEnabled()) {
            log.warn(e.getMessage(), e);
        }
        throw e;
    }

    /**
     * システム例外のハンドリング
     *
     * @param e
     * @throws Throwable
     */
    public void afterThrowing(SystemException e) throws Throwable {
        e.setMessage(messageAccessor.getMessage(e.getErrorCode(), e
                .getOptions()));
        if (log.isErrorEnabled()) {
            log.error(e.getMessage(), e);
        }
        throw e;
    }

    /**
     * その他ハンドリングされなかった例外の対処
     *
     * @param e
     * @throws Throwable
     */
    public void afterThrowing(Exception e) throws Throwable {
        String message = messageAccessor.getMessage("ERROR_COMMON_0001",
                new String[0]);
        if (log.isErrorEnabled()) {
            log.error(message, e);
        }
        SystemException exception = new SystemException(e, "ERROR_COMMON_0001");
        exception.setMessage(message);
        throw exception;
    }

}
