package jp.terasoluna.rich.tutorial.service.calc.validation;

import org.springframework.validation.Errors;

import jp.terasoluna.fw.validation.springmodules.BaseMultiFieldValidator;
import jp.terasoluna.rich.tutorial.service.calc.dto.CalcInputDto;

public class AddCustomValidator extends BaseMultiFieldValidator {

    @Override
    protected void validateMultiField(Object obj, Errors errors) {
        CalcInputDto inputDto = (CalcInputDto) obj;
        /// フレームワークのカスタム入力チェックの実装方法理解のため
        /// このサンプルAPでは、数値1と数値2が等しいときに入力チェックエラーとする
        if (inputDto.getNum1() == inputDto.getNum2()) {
            errors.reject("ERROR_CALC_MSG001");
        }
    }

}
