package jp.terasoluna.rich.tutorial.service.calc.service;

import javax.jws.WebMethod;
import javax.jws.WebService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import jp.terasoluna.rich.tutorial.service.calc.bizLogic.CalcBizLogic;
import jp.terasoluna.rich.tutorial.service.calc.dto.CalcInputDto;
import jp.terasoluna.rich.tutorial.service.calc.dto.CalcOutputDto;
import jp.terasoluna.rich.tutorial.service.common.exception.SampleSoapFaultException;
import jp.terasoluna.rich.tutorial.service.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.rich.tutorial.service.common.validation.SampleValidator;

/**
*
* 通常のWebサービスのサンプル
* SpringBeanAutowiringSupportを継承し作成する
*
*/
@WebService(serviceName = "CalcService")
public class CalcService extends SpringBeanAutowiringSupport {

    @Autowired
    private CalcBizLogic bizLogic;

    @Autowired
    @Qualifier("addValidator")
    private SampleValidator validator;

    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;

    /**
     * 足し算する
     * @param param
     * @return
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "Add")
    public CalcOutputDto add(CalcInputDto param)
            throws SampleSoapFaultException {
        try {
            // 入力チェック
            validator.validate(param);
            // ビジネスロジック実行
            return bizLogic.Add(param);
        } catch (Exception e) {
            // エラーハンドリング
            exceptionHandler.handleException(e);
        }
        return null;
    }
}
