package jp.terasoluna.toursample.server.interfaces.tour.dto;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import jp.terasoluna.toursample.server.interfaces.tour.code.TourTypeEnum;
import jp.terasoluna.toursample.server.interfaces.tour.code.TransportationEnum;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TourDto")
public class TourDto {
    @XmlElement(name = "TourCode")
    private String tourCode;
    @XmlElement(name = "Name")
    private String name;
    @XmlElement(name = "TourType")
    private TourTypeEnum tourType;
    @XmlElement(name = "Transportation")
    private TransportationEnum transportation;
    @XmlElement(name = "TourCategoryList")
    private List<TourCategoryDto> tourCategoryList;
    @XmlElement(name = "DeptPlaceList")
    private List<DeptPlaceDto> deptPlaceList;
    @XmlElement(name = "DestName")
    private String destName;
    @XmlElement(name = "DeptDate")
    private Date deptDate;
    @XmlElement(name = "TourDay")
    private Integer tourDay;
    @XmlElement(name = "HasOptionalTour")
    private boolean hasOptionalTour;
    @XmlElement(name = "HotelRank")
    private HotelRankDto hotelRank;
    @XmlElement(name = "ConductorList")
    private List<ConductorDto> conductorList;
    @XmlElement(name = "Version")
    private int version = 0;

    public TourDto() {
    }

    public TourDto(String tourCode, TransportationEnum transportation,
            String name, String destName, Date deptDate, Integer tourDay,
            List<ConductorDto> conductorList, int version) {
        this.tourCode = tourCode;
        this.transportation = transportation;
        this.name = name;
        this.destName = destName;
        this.deptDate = deptDate;
        this.tourDay = tourDay;
        this.conductorList = conductorList;
        this.version = version;
    }

    public String getTourCode() {
        return tourCode;
    }

    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TourTypeEnum getTourType() {
        return tourType;
    }

    public void setTourType(TourTypeEnum tourType) {
        this.tourType = tourType;
    }

    public TransportationEnum getTransportation() {
        return transportation;
    }

    public void setTransportation(TransportationEnum transportation) {
        this.transportation = transportation;
    }

    public List<TourCategoryDto> getTourCategoryList() {
        return tourCategoryList;
    }

    public void setTourCategoryList(List<TourCategoryDto> tourCategoryList) {
        this.tourCategoryList = tourCategoryList;
    }

    public List<DeptPlaceDto> getDeptPlaceList() {
        return deptPlaceList;
    }

    public void setDeptPlaceList(List<DeptPlaceDto> deptPlaceList) {
        this.deptPlaceList = deptPlaceList;
    }

    public String getDestName() {
        return destName;
    }

    public void setDestName(String destName) {
        this.destName = destName;
    }

    public Date getDeptDate() {
        return deptDate;
    }

    public void setDeptDate(Date deptDate) {
        this.deptDate = deptDate;
    }

    public Integer getTourDay() {
        return tourDay;
    }

    public void setTourDay(Integer tourDay) {
        this.tourDay = tourDay;
    }

    public boolean isHasOptionalTour() {
        return hasOptionalTour;
    }

    public void setHasOptionalTour(boolean hasOptionalTour) {
        this.hasOptionalTour = hasOptionalTour;
    }

    public HotelRankDto getHotelRank() {
        return hotelRank;
    }

    public void setHotelRank(HotelRankDto hotelRank) {
        this.hotelRank = hotelRank;
    }

    public List<ConductorDto> getConductorList() {
        return conductorList;
    }

    public void setConductorList(List<ConductorDto> conductorList) {
        this.conductorList = conductorList;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

}
