package jp.terasoluna.toursample.server.domain.model;

import jp.terasoluna.toursample.server.domain.code.RoleEnum;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ユーザクラス
 *
 */
public class User {

    private String id;
    private String password;
    private String name;
    private String email;
    private String address;
    private String companyName;
    private RoleEnum role;
    private int version = 0;

    public User() {
    }

    public User(String id, String password) {
        this.id = id;
        this.password = password;
    }

    public User(String id, String password, String name, RoleEnum role, String email, String address, String companyName, int version)
    {
        this.id = id;
        this.password = password;
        this.name = name;
        this.email = email;
        this.address = address;
        this.companyName = companyName;
        this.role = role;
        this.version = version;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public RoleEnum getRole() {
        return role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    /**
     * ダミーのドメインロジック
     *
     * @return
     */
    public void doSomething() {
        System.out.println("Userのビジネスロジック実行");
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("password",
                password).append("name", name).append("email", email).append(
                "address", address).append("companyName", companyName).append(
                "role", role).append("version", version).toString();
    }

}
