package jp.terasoluna.toursample.server.domain.model;

import java.util.List;

/**
 * TourクラスのRepository
 *
 */
public interface TourRepository {

    /**
     * ツアーを追加する
     *
     * @param tour
     */
    void store(Tour tour);

    /**
     * ツアーを取得する
     *
     * @param tourCode
     *            ツアーコード
     * @return ツアー
     */
    Tour find(String tourCode);

    /**
     * ツアー名称でツアー検索する
     *
     * @param tourName
     *            ツアー名称
     * @return ツアー
     */
    List<Tour> findByTourName(String tourName);

    /**
     * ツアー分類リストを取得する
     * @return
     */
    List<TourCategory> findAllCategories();

    /**
     * 出発地リストを取得する
     * @return
     */
    List<DeptPlace> findAllDeptPlaces();

}
