package jp.terasoluna.toursample.server.domain.model;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 担当者クラス
 *
 */
public class Conductor {
    private String id;
    private String tourCode;
    private String name;
    private String email;
    private int version;

    public Conductor() {
    }

    public Conductor(String id, String name, String email, int version) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.version = version;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTourCode() {
        return tourCode;
    }

    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    /**
     * ダミーのドメインロジック
     *
     * @return
     */
    public void doSomething() {
        System.out.println("Conductorのビジネスロジック実行");
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", id).append("tourCode",
                tourCode).append("name", name).append("email", email).append(
                "version", version).toString();
    }

}
