﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace Terasoluna.TourSample.Client.Common.FileCheck
{
    /// <summary>
    /// ファイルチェックのためのインタフェース
    /// </summary>
    public interface IFileChecker
    {
        /// <summary>
        /// 進捗通知イベント
        /// </summary>
        event EventHandler<ProgressChangedEventArgs> ProgressChanged;
        
        /// <summary>
        /// ファイルチェック
        /// </summary>
        FileCheckResult CheckFile(String filePath);

        /// <summary>
        /// ディレクトリ配下に存在するファイルをチェックする
        /// </summary>
        List<FileCheckResult> CheckFiles(String dirPath);
    }
}
