﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.DataCopy;


namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ登録画面(1/3)
    /// </summary>
    [ScreenId("SC_B01_02_01")]
    public partial class SC_B01_02_01View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public SC_B01_02_01ViewData ViewData { get; set; }

        public SC_B01_02_01View()
        {
            InitializeComponent();
            ViewData = ValidatableViewDataManager.CreateViewData<SC_B01_02_01ViewData>();
        }

        private void SC_B01_02_01View_Load(object sender, EventArgs e)
        {
            sC_B01_02_01ViewDataBindingSource.DataSource = ViewData;
        }

        /// <summary>
        /// 戻るボタン押下
        /// </summary>
        private void backButton_Click(object sender, EventArgs e)
        {
            //スコープ上の画面を全てクローズ
            FormForwardGroupUtility.CloseAll(this);
            //スコープ開始画面の場合は、Closeメソッドでも同等の効果がある
            //Close();
        }

        /// <summary>
        /// 次へボタン押下
        /// </summary>
        private void forwardToSC_B01_02_02Button_Click(object sender, EventArgs e)
        {
            EventProcessResult result = b01_02_01_C01EventProcessWorker.RunWorker();
            if (result.IsSuccess)
            {
                formForwarderToSC_B01_02_02.Forward();
            }
        }

        /// <summary>
        /// 次画面遷移時
        /// </summary>
        private void formForwarderToSC_B01_02_02_ForwardFormLoading(object sender, ForwardFormLoadingEventArgs e)
        {
            //ユーザ情報登録確認画面へ引き継ぐため、
            //画面遷移前にスコープ共通領域に画面データを保存
            SC_B01_02_01ViewData sC_B01_02_01ViewData = 
                ValidatableViewDataManager.CreateViewData<SC_B01_02_01ViewData>();
            //ディープコピーして共通領域に格納
            DataCopyManager.Copy(ViewData, sC_B01_02_01ViewData);
            FormForwardManager.GetScope(this)["SC_B01_02_01ViewData"] = sC_B01_02_01ViewData;
        }

        private void helpButton_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "sample.chm");
        }

    }
}
