﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.TourSample.Client.B01.ViewData;

namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ管理業務画面のメインコンテンツが実装するインタフェース
    /// </summary>
    public interface ISC_B01_03_01MainContent
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        object ViewData { get; }

        /// <summary>
        /// ログインユーザ
        /// メインのパネルの外のヘッダー領域に表示する
        /// </summary>
        SC_B01_03LoginUser LoginUser { get; }

        /// <summary>
        /// 画面のタイトル
        /// </summary>
        string Title { get; }

        /// <summary>
        /// 実行ボタンに表示する文字列
        /// </summary>
        string ExecuteButtonCaption { get; }

        /// <summary>
        /// 実行ボタンを有効にするか
        /// </summary>
        bool ExecutionEnabled { get; }        

        /// <summary>
        /// 戻るボタンを有効にするか
        /// </summary>
        bool BackEnabled { get; }

        /// <summary>
        /// ヘルプボタンを有効にするか
        /// </summary>
        bool HelpEnabled { get; }

        /// <summary>
        /// ヘルプボタン押下によるヘルプファイルのURL
        /// </summary>
        string HelpUrl { get; }  
        
        /// <summary>
        /// 実行ボタン押下による処理を実行する
        /// </summary>
        void Execute();

        /// <summary>
        /// 戻るボタン押下による処理を実行する
        /// </summary>
        void Back();

    }
}
