﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Reflection;
using Terasoluna.TourSample.Client.Common.Code;
using System.Drawing.Design;
using Terasoluna.TourSample.Client.A01.ViewData;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ホテルランクのチェックボックスを表示する画面部品
    /// </summary>
    public partial class SC_A01_01_01_02UserControl : UserControl
    {
        public SC_A01_01_01_02UserControl()
        {
            InitializeComponent();
        }

        ///バインド対象のプロパティ
        [Bindable(true)]
        public virtual SC_A01_01_01HotelRank HotelRank
        {
            get
            {
                return sC_A01_01_01HotelRankBindingSource.DataSource as SC_A01_01_01HotelRank;
            }

            set
            {
                if (sC_A01_01_01HotelRankBindingSource.DataSource == value)
                {
                    return;
                }
                if (value == null)
                {
                    sC_A01_01_01HotelRankBindingSource.DataSource = typeof(SC_A01_01_01HotelRank);
                }
                else
                {
                    sC_A01_01_01HotelRankBindingSource.DataSource = value;
                }               
                //値が変更されたらイベントを発生させる
                OnHotelRankChanged(EventArgs.Empty);
            }
        }
        
        /// PropertyNameChangedパターン
        public event EventHandler HotelRankChanged;
        
        /// <summary>
        /// HotelRankChangedイベントの発火
        /// </summary>        
        protected virtual void OnHotelRankChanged(EventArgs e)
        {
            EventHandler handler = HotelRankChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }
    }
}
