package jp.terasoluna.toursample.server.common.code;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * コード情報を保持するクラス
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SelectableValue", namespace = "http://jp.terasoluna.toursample")
public class SelectableValue {
    @XmlElement(name ="DiplayName")
    private String displayName;
    @XmlElement(name ="Value")
    private String value;

    public SelectableValue()
    {

    }

    public SelectableValue(String displayName, String value)
    {
        this.displayName = displayName;
        this.value = value;
    }

    public String getDisplayName() {
        return displayName;
    }
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return new ToStringBuilder(this).append("displayName", displayName)
                .append("value", value).toString();
    }



}
