package jp.terasoluna.toursample.server.common.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ビジネスロジック実行前後でログを取得するサンプル実装
 *
 */
public class SampleAroundAdvice implements MethodInterceptor {
    private static Log log = LogFactory.getLog(SampleAroundAdvice.class);
    private static final String LINE_SEPARATOR = System
            .getProperty("line.separator");

    public Object invoke(MethodInvocation methodinvocation) throws Throwable {

        // メソッドの開始をInfoログ出力
        if (log.isInfoEnabled()) {
            log.info(methodinvocation.getThis().getClass().getName() + "."
                    + methodinvocation.getMethod().getName() + ":開始");
        }
        // メソッドの引数をDebugログ出力
        if (log.isDebugEnabled()) {
            Object[] args = methodinvocation.getArguments();

            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; i++) {
                sb.append("第").append(i + 1).append("引数：");
                // ToStringの実装が必要
                sb.append((args[i] == null) ? "null" : args[i].toString());
                if (i != args.length - 1) {
                    sb.append(LINE_SEPARATOR);
                }
            }
            log.debug(sb.toString());
        }

        Object result = methodinvocation.proceed();

        // メソッドの終了をInfoログ出力
        if (log.isInfoEnabled()) {
            log.info(methodinvocation.getThis().getClass().getName() + "."
                    + methodinvocation.getMethod().getName() + ":終了");
        }

        // メソッドの戻り値をDebugログ出力
        if (log.isDebugEnabled()) {
            if (!"void".equals(methodinvocation.getMethod().getReturnType().getName())) {
                // ToStringの実装が必要
                log.debug("戻り値："
                        + ((result == null) ? "null" : result.toString()));
            } else {
                log.debug("戻り値：なし");
            }
        }

        return result;
    }
}
