﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.ExceptionHandling;

namespace Terasoluna.TourSample.Client.Common.VirusCheck
{
    /// <summary>
    /// ウィルスチェック結果を保持するクラス
    /// </summary>
    public class VirusCheckResult
    {
        public VirusCheckResult(VirusCheckStatus status, string fileName, ErrorInfo error, string virusName)
        {
            Status = status;
            FileName = fileName;
            Error = error;
            VirusName = virusName;
        }

        /// <summary>
        /// チェック対象のファイル名
        /// </summary>
        public string FileName { get; private set; }

        /// <summary>
        /// エラー情報
        /// </summary>
        public ErrorInfo Error { get; private set; }

        /// <summary>
        /// ウィルス名
        /// </summary>
        public string VirusName { get; private set; }

        /// <summary>
        /// ウィルスチェック処理の状態
        /// </summary>
        public VirusCheckStatus Status { get; private set; }

    }
}
