﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using Terasoluna.Validation.Validators;
using Terasoluna.Windows.ViewModel.Validation;
using System.Text.RegularExpressions;

namespace Terasoluna.TourSample.Client.Common.ViewData
{
    /// <summary>
    /// 担当者の共通画面データクラス
    /// </summary>
    public class Conductor : ValidatableNestedViewData
    {
        ///共通データ定義書の論理項目名をもとにDisplayNameを決定 
        [DisplayName("名前")]
        ///画面設計書（入力チェック）の表示名をもとにTagを決定
        [RequiredValidator(Tag = "担当者名", Ruleset = "CRS01")]
        [ZenkakuStringValidator(Tag = "担当者名", Ruleset = "CRS01")]
        public virtual string Name { get; set; }

        [DisplayName("メールアドレス")]
        [RequiredValidator(Tag = "メールアドレス", Ruleset = "CRS01")]
        [RegexValidatorEx(@"\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*",
            RegexOptions.IgnoreCase, Tag = "メールアドレス", Ruleset = "CRS01")]
        public virtual string Email { get; set; }
    }
}
