﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.ExceptionHandling;

namespace Terasoluna.TourSample.Client.Common.FileCheck
{
    /// <summary>
    /// ファイルチェック結果を保持するクラス
    /// </summary>
    public class FileCheckResult
    {
        public FileCheckResult(string fileName, ErrorInfo error)
        {
            FileName = fileName;
            Error = error;
        }

        /// <summary>
        /// チェック結果が成功したか
        /// </summary>
        public bool IsSuccess {
            get
            {
                return (Error == null);
            }
        }
        /// <summary>
        /// チェック対象のファイル名
        /// </summary>
        public string FileName { get; private set; }

        /// <summary>
        /// エラー情報
        /// </summary>
        public ErrorInfo Error { get; private set; }

    }
}
