﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.SelectableValues;
using Terasoluna.BizLogic;
using Terasoluna.TourSample.Client.Common.BizLogic;

namespace Terasoluna.TourSample.Client.Common.Code
{
    /// <summary>
    /// コードリストを定義するExtensionクラス
    /// </summary>
    public class TourSelectableValuesExtension : SelectableValuesExtension
    {
        protected override void Setup()
        {
            base.Setup();
            RegisterFromEnum("交通機関", typeof(TransportationEnum));
            RegisterFromBizLogic("ツアー出発地",
                new BizLogicInfo("ClientBizLogic", typeof(CodeListBizLogic), null, "GetDeptPlaces"));            
            RegisterFromBizLogic("ツアー分類",
                new BizLogicInfo("ClientBizLogic", typeof(CodeListBizLogic), null, "GetTourCategories"));
        }
    }
}
