﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.Common.ViewData;
using Terasoluna.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using Microsoft.Practices.EnterpriseLibrary.Validation;

namespace Terasoluna.TourSample.Client.B01.ViewData
{
    /// <summary>
    /// ユーザ登録画面(1/3)の画面データクラス（ルート）
    /// </summary>
    [HasSelfValidation]
    [DefaultRuleset("RS01")]
    [RulesetMapping("RS01", "CRS02", "User")]
    public partial class SC_B01_03_01ViewData : ValidatableRootViewData
    {
        public virtual User User { get; set; }

        [DisplayName("確認用パスワード")]
        [RequiredValidator(Tag = "確認用パスワード", Ruleset = "RS01")]
        public virtual string ConfirmPassword { get; set; }

        /// <summary>
        /// ログインユーザ
        /// 
        /// メインのパネルの外のヘッダー領域に表示する
        /// </summary>
        public virtual User LoginUser { get; set; }

        /// <summary>
        /// クラス階層が異なるプロパティ同士の相関チェックの例
        /// </summary>
        /// <param name="results"></param>
        [SelfValidation(Ruleset = "RS01")]
        private void CustomValidate01(ValidationResults results)
        {
            //クラス階層が異なる項目の場合のカスタム入力チェック
            User.ClearPasswordCustomeError();
            if (!string.Equals(User.Password, ConfirmPassword, StringComparison.Ordinal))
            {
                results.AddResult(
                    new ValidationResult(Terasoluna.TourSample.Client.Common.Properties.Resources.ERROR_COMMON_0004,
                        this, "ConfirmPassword", null, EventSpecificValidator.DefaultInstance));
                
                ///メソッドを作成し対象の画面データ（ネスト）側にエラーを通知
                User.SetPasswordCustomeError(Terasoluna.TourSample.Client.Common.Properties.Resources.ERROR_COMMON_0004);
            }
        }
    }
}
