package jp.terasoluna.toursample.server.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.toursample.server.a01.dto.A01_01_01_S01TourDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01TourDto;

import org.springframework.dao.DataIntegrityViolationException;

/**
 * DBの代わりのダミーのデータストア
 */
public class TourDataStore {

    private static TourDataStore singleton = new TourDataStore();
    private Map<String, A01_01_01_S01TourDto> map = new HashMap<String, A01_01_01_S01TourDto>();

    private TourDataStore() {

    }

    public static TourDataStore getInstance() {
        return singleton;
    }

    public void insert(A01_01_01_S01TourDto tour) {
        if (map.containsKey(tour.getTourCode())) {
            // DB上での主キーの重複を想定したダミーの例外
            throw new DataIntegrityViolationException("すでに存在するTourCodeです。");
        }
        map.put(tour.getTourCode(), tour);
    }

    public A01_01_01_S01TourDto findA01_01_01_C01TourByKey(String tourCode) {
        return map.get(tourCode);
    }

    public List<A01_02_01_S01TourDto> findA01_02_01_C01TourByName(String tourName) {
        ArrayList<A01_02_01_S01TourDto> list = new ArrayList<A01_02_01_S01TourDto>();

        for (A01_01_01_S01TourDto tour : map.values()) {
            if (tour.getTourName() != null
                    && tour.getTourName().startsWith(tourName)) {
                A01_02_01_S01TourDto tourView = new A01_02_01_S01TourDto();
                tourView.setDestName(tour.getDestName());
                tourView.setTourCode(tour.getTourCode());
                tourView.setTourName(tour.getTourName());
                list.add(tourView);
            }
        }
        sort(list);
        return list;
    }

    /**
     * ツアーコードでソート
     */
    private void sort(List<A01_02_01_S01TourDto> list) {
        Collections.sort(list, new Comparator<A01_02_01_S01TourDto>() {
            public int compare(A01_02_01_S01TourDto tour1, A01_02_01_S01TourDto tour2) {
                String tour1Code = tour1.getTourCode();
                String tour2Code = tour2.getTourCode();
                if (tour1Code.compareTo(tour2Code) < 0) {
                    return -1;
                } else if (tour1Code.compareTo(tour2Code) > 0) {
                    return 1;
                }
                return 0;
            }
        });

    }
}
