package jp.terasoluna.toursample.server.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.toursample.server.b01.dto.B01_01_01_S01InputDto;
import jp.terasoluna.toursample.server.b01.dto.B01_01_01_S01OutputDto;
import jp.terasoluna.toursample.server.common.code.RoleEnum;
import jp.terasoluna.toursample.server.common.code.SelectableValue;

/**
 *  QueryDAOのモッククラス
 *
 */
public class MockQueryDAO implements QueryDAO {

    public Map<String, Object> executeForMap(String arg0, Object arg1) {

        return null;
    }

    public Map<String, Object>[] executeForMapArray(String arg0, Object arg1) {

        return null;
    }

    public Map<String, Object>[] executeForMapArray(String arg0, Object arg1,
            int arg2, int arg3) {

        return null;
    }

    public List<Map<String, Object>> executeForMapList(String arg0, Object arg1) {

        return null;
    }

    public List<Map<String, Object>> executeForMapList(String arg0,
            Object arg1, int arg2, int arg3) {

        return null;
    }

    public <E> E executeForObject(String sqlId, Object obj, Class clazz) {
        if ("B01.selectUserByIdAndPass".equals(sqlId) && obj != null
                && obj instanceof B01_01_01_S01InputDto) {
            B01_01_01_S01InputDto input = (B01_01_01_S01InputDto) obj;
            if ("terasoluna".equals(input.getUserId())
                    && "password".equals(input.getPassword())) {
                // ユーザID = "terasoluna" パスワード = "password"なら管理者ユーザでログイン
                B01_01_01_S01OutputDto output = new B01_01_01_S01OutputDto();
                output.setRole(RoleEnum.Admin);
                output.setUserName("テラソルナ");
                return (E) output;
            } else if ("user01".equals(input.getUserId())
                    && "password".equals(input.getPassword())) {
                // ユーザID = "guest" パスワード = "password"なら一般ユーザでログイン
                B01_01_01_S01OutputDto output = new B01_01_01_S01OutputDto();
                output.setRole(RoleEnum.User);
                output.setUserName("ユーザ01");
                return (E) output;
            }
        }
        return null;
    }

    public <E> E[] executeForObjectArray(String arg0, Object arg1, Class arg2) {

        return null;
    }

    public <E> E[] executeForObjectArray(String arg0, Object arg1, Class arg2,
            int arg3, int arg4) {

        return null;
    }

    public <E> List<E> executeForObjectList(String sqlId, Object obj) {
        if ("A01.selectTourByTourName".equals(sqlId) && obj != null
                && obj instanceof String) {
            return (List<E>) TourDataStore.getInstance()
                    .findA01_02_01_C01TourByName((String) obj);
        } else if ("COMMON.selectDeptPlaces".equals(sqlId)) {
            ArrayList<SelectableValue> codeList = new ArrayList<SelectableValue>();
            codeList.add(new SelectableValue("東京","Tokyo"));
            codeList.add(new SelectableValue("大阪","Osaka"));
            codeList.add(new SelectableValue("名古屋","Nagoya"));
            codeList.add(new SelectableValue("福岡","Fukuoka"));
            codeList.add(new SelectableValue("札幌","Sapporo"));
            return (List<E>) codeList;
        } else if ("COMMON.selectTourCategories".equals(sqlId)) {
            ArrayList<SelectableValue> codeList = new ArrayList<SelectableValue>();
            codeList.add(new SelectableValue("遊園地・テーマパーク","AmusementPark"));
            codeList.add(new SelectableValue("グルメ","Gourmet"));
            codeList.add(new SelectableValue("温泉","HotSpring"));
            codeList.add(new SelectableValue("スキー・スノボード","Ski"));
            codeList.add(new SelectableValue("ビーチ・海水浴","Beach"));
            codeList.add(new SelectableValue("ダイビング","Diving"));
            codeList.add(new SelectableValue("ゴルフ","Golf"));
            return (List<E>) codeList;
        }
        return null;
    }

    public <E> List<E> executeForObjectList(String arg0, Object arg1, int arg2,
            int arg3) {

        return null;
    }

}
