package jp.terasoluna.toursample.server.common.code;

import java.sql.SQLException;
import java.sql.Types;

import com.ibatis.sqlmap.client.extensions.ParameterSetter;
import com.ibatis.sqlmap.client.extensions.ResultGetter;
import com.ibatis.sqlmap.client.extensions.TypeHandlerCallback;

/**
 * TransportationEnum用のTypeHandlerCallback
 */
public class TransportationEnumTypeHandler implements TypeHandlerCallback {

    @Override
    public Object getResult(ResultGetter getter) throws SQLException {
        return valueOf(getter.getString());
    }

    @Override
    public void setParameter(ParameterSetter setter, Object param)
            throws SQLException {
        if (param == null) {
            setter.setNull(Types.VARCHAR);
        } else {
            TransportationEnum value = (TransportationEnum) param;
            setter.setString(value.toString());
        }

    }

    @Override
    public Object valueOf(String str) {
        return TransportationEnum.valueOf(str);
    }

}
