package jp.terasoluna.toursample.server.b01.service;

import javax.jws.WebMethod;
import javax.jws.WebService;

import jp.terasoluna.toursample.server.b01.bizlogic.B01_02BizLogic;
import jp.terasoluna.toursample.server.b01.dto.B01_02_03_S01InputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.validation.SampleValidator;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * 通常のWebサービスのサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 *
 */
@WebService(serviceName="B01_02Service", targetNamespace = "http://jp.terasoluna.toursample")
public class B01_02Service extends SpringBeanAutowiringSupport {

    @Autowired
    private B01_02BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;
    @Autowired
    @Qualifier("defaultValidator")
    private SampleValidator defaultValidator;

    /**
     * ユーザ登録する
     * @param input
     * @throws SampleSoapFaultException
     */
    @WebMethod(operationName = "ExecuteB01_02_03_S01")
    public void executeB01_02_03_S01(B01_02_03_S01InputDto input)
            throws SampleSoapFaultException {
        try {
            // 入力チェック処理の実施
            defaultValidator.validate(input);
            // ビジネスロジックの実施
            bizLogic.executeB01_02_03_S01(input);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
    }


}
