package jp.terasoluna.toursample.server.a01.service;

import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.soap.MTOM;

import jp.terasoluna.toursample.server.a01.bizlogic.A01_03BizLogic;
import jp.terasoluna.toursample.server.a01.dto.A01_03_01_S02InputDto;
import jp.terasoluna.toursample.server.common.exception.SampleSoapFaultException;
import jp.terasoluna.toursample.server.common.exception.handler.SampleSoapFaultExceptionHandler;
import jp.terasoluna.toursample.server.common.mtom.StreamBody;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/**
 *
 * MTOMを使ったアップロード/ダウンロードのWebサービスサンプル
 * SpringBeanAutowiringSupportを継承し作成する
 */
@MTOM
@WebService(serviceName = "A01_03MtomService")
public class A01_03MtomService extends SpringBeanAutowiringSupport {
    @Autowired
    private A01_03BizLogic bizLogic;
    @Autowired
    private SampleSoapFaultExceptionHandler exceptionHandler;

    /**
     * WCFクライアント側でStreamでファイルアップロードを扱うサンプル
     * メソッドの引数をStreamBodyを１つだけもつようにしないとクライアント側はbyte[]になってしまう。
     * このため、ストリームといっしょにテキスト情報を送ることができない
     */
    @WebMethod(operationName = "ExecuteA01_03_01_S01")
    public void executeA01_03_01_S01(StreamBody streamBody)
            throws SampleSoapFaultException {
        try {
            bizLogic.executeA01_03_01_S01(streamBody.getStream());
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
    }

    /**
     * WCFクライアント側でバイト配列でファイルアップロードを扱うサンプル
     * バイトデータ以外にも、テキスト情報も一緒に送れる
     */
    @WebMethod(operationName = "ExecuteA01_03_01_S02")
    public void executeA01_03_01_S02(A01_03_01_S02InputDto inputDto)
            throws SampleSoapFaultException {
        try {
            bizLogic.executeA01_03_01_S02(inputDto);
        } catch (Exception e) {
            // 例外が発生した場合に、必要に応じてSampleSoapFaultExceptionをスロー
            exceptionHandler.handleException(e);
        }
    }

}
