package jp.terasoluna.toursample.server.a01.dto;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import jp.terasoluna.toursample.server.common.code.TourTypeEnum;
import jp.terasoluna.toursample.server.common.code.TransportationEnum;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "A01_01_01_S01TourDto", namespace = "http://jp.terasoluna.toursample")
public class A01_01_01_S01TourDto {

    @XmlElement(name = "TourCode", namespace = "http://jp.terasoluna.toursample")
    private String tourCode;
    @XmlElement(name = "TourName", namespace = "http://jp.terasoluna.toursample")
    private String tourName;
    @XmlElement(name = "TourType", namespace = "http://jp.terasoluna.toursample")
    private TourTypeEnum tourType;
    @XmlElement(name = "Transportation", namespace = "http://jp.terasoluna.toursample")
    private TransportationEnum transportation;
    @XmlElement(name = "TourCategoryList", namespace = "http://jp.terasoluna.toursample")
    private List<A01_01_01_S01TourCategoryDto> tourCategoryList;
    @XmlElement(name = "DeptPlaceList", namespace = "http://jp.terasoluna.toursample")
    private List<A01_01_01_S01DeptPlaceDto> deptPlaceList;
    @XmlElement(name = "DestName", namespace = "http://jp.terasoluna.toursample")
    private String destName;
    @XmlElement(name = "DeptDate", namespace = "http://jp.terasoluna.toursample")
    private Date deptDate;
    @XmlElement(name = "TourDay", namespace = "http://jp.terasoluna.toursample")
    private Integer tourDay;
    @XmlElement(name = "HasOptionalTour", namespace = "http://jp.terasoluna.toursample")
    private boolean hasOptionalTour;
    @XmlElement(name = "HotelRank", namespace = "http://jp.terasoluna.toursample")
    private A01_01_01_S01HotelRankDto hotelRank;

    public String getTourCode() {
        return tourCode;
    }
    public void setTourCode(String tourCode) {
        this.tourCode = tourCode;
    }
    public String getTourName() {
        return tourName;
    }
    public void setTourName(String tourName) {
        this.tourName = tourName;
    }
    public TourTypeEnum getTourType() {
        return tourType;
    }
    public void setTourType(TourTypeEnum tourType) {
        this.tourType = tourType;
    }
    public TransportationEnum getTransportation() {
        return transportation;
    }
    public void setTransportation(TransportationEnum transportation) {
        this.transportation = transportation;
    }
    public List<A01_01_01_S01TourCategoryDto> getTourCategoryList() {
        return tourCategoryList;
    }
    public void setTourCategoryList(
            List<A01_01_01_S01TourCategoryDto> tourCategoryList) {
        this.tourCategoryList = tourCategoryList;
    }
    public List<A01_01_01_S01DeptPlaceDto> getDeptPlaceList() {
        return deptPlaceList;
    }
    public void setDeptPlaceList(List<A01_01_01_S01DeptPlaceDto> deptPlaceList) {
        this.deptPlaceList = deptPlaceList;
    }
    public String getDestName() {
        return destName;
    }
    public void setDestName(String destName) {
        this.destName = destName;
    }
    public Date getDeptDate() {
        return deptDate;
    }
    public void setDeptDate(Date deptDate) {
        this.deptDate = deptDate;
    }
    public Integer getTourDay() {
        return tourDay;
    }
    public void setTourDay(Integer tourDay) {
        this.tourDay = tourDay;
    }
    public boolean isHasOptionalTour() {
        return hasOptionalTour;
    }
    public void setHasOptionalTour(boolean hasOptionalTour) {
        this.hasOptionalTour = hasOptionalTour;
    }
    public A01_01_01_S01HotelRankDto getHotelRank() {
        return hotelRank;
    }
    public void setHotelRank(A01_01_01_S01HotelRankDto hotelRank) {
        this.hotelRank = hotelRank;
    }
    public String toString() {
        return new ToStringBuilder(this).append("tourCode", tourCode).append(
                "tourName", tourName).append("tourType", tourType).append(
                "transportation", transportation).append("tourCategoryList",
                tourCategoryList).append("deptPlaceList", deptPlaceList)
                .append("destName", destName).append("deptDate", deptDate)
                .append("tourDay", tourDay).append("hasOptionalTour",
                        hasOptionalTour).append("hotelRank", hotelRank)
                .toString();
    }


}
