package jp.terasoluna.toursample.server.a01.bizlogic;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

import org.springframework.beans.factory.annotation.Autowired;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01OutputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01TourCollection;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S01TourDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S02InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S03InputDto;
import jp.terasoluna.toursample.server.a01.dto.A01_02_01_S03OutputDto;
import jp.terasoluna.toursample.server.common.exception.ApplicationException;

public class A01_02BizLogicImpl implements A01_02BizLogic {
    // 一時保存フォルダ
    private static final String TEMP_DIR = "C:\\tmp\\";

    //ファイル保存するだけのダミー処理

    // サンプルのデフォルトは、MockDAOになっているので、DB接続したい場合は、
    // h2dbフォルダ内にあるH2DBを動作させること
    // また、環境設定手順の詳細はプロジェクト直下のreadme_h2db.txtを参照のこと
    @Autowired
    private QueryDAO queryDAO;

    @Override
    public A01_02_01_S01OutputDto executeA01_02_01_S01(
            A01_02_01_S01InputDto input) throws ApplicationException {
        // ツアーの検索
        List<A01_02_01_S01TourDto> tourList = queryDAO.executeForObjectList(
                "A01.selectTourByTourName", input.getTourName());
        A01_02_01_S01OutputDto result = new A01_02_01_S01OutputDto();
        result.setTourList(new A01_02_01_S01TourCollection(tourList));
        return result;
    }

    @Override
    public DataHandler executeA01_02_01_S02(A01_02_01_S02InputDto input)
            throws ApplicationException {
        File file = new File(TEMP_DIR + "downloadFileWithStream.dat");
        // テストデータを書き込んだダウンロードファイルの作成
        Writer writer = null;
        try {
            file.createNewFile();
            writer = new OutputStreamWriter(new BufferedOutputStream(
                    new FileOutputStream(file)), "UTF-8");
            writer.write("テスト");
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
        return new DataHandler(new FileDataSource(file));
    }

    @Override
    public A01_02_01_S03OutputDto executeA01_02_01_S03(
            A01_02_01_S03InputDto input) throws ApplicationException {
        // テストデータを書き込んだダウンロードファイルの作成
        Writer writer = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            writer = new OutputStreamWriter(new BufferedOutputStream(bos),
                    "UTF-8");
            writer.write("テスト2");
        } catch (IOException e) {
            throw new SystemException(e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    throw new SystemException(e);
                }
            }
        }
        // ファイル名の設定
        A01_02_01_S03OutputDto outputDto = new A01_02_01_S03OutputDto();
        if (bos != null) {
            outputDto.setFileData(bos.toByteArray());
            outputDto.setFileName("出力結果.txt");
        }
        return outputDto;
    }
}
