﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Terasoluna.TourSample.Client.Common.View
{
    /// <summary>
    /// ツアーサンプルプロジェクトの基底画面クラス
    /// レイアウトなどUI規約に基づく基本的な設定をする
    ///
    /// 画面表示を画面中央(StartPosition=CenterScreen)
    /// 最大化ボタン、最小化ボタンの消去(MaximizeSizeBox,MinimizeSizeBox = false)
    /// ウィンドウ枠の固定(FomrBorderStyle = FixedSingle)
    /// ステータスバーの貼り付け
    /// 
    /// </summary>
    public partial class TourSampleViewBase : Form
    {
        public TourSampleViewBase()
        {
            InitializeComponent();
        }

        private void TourSampleViewBase_Load(object sender, EventArgs e)
        {
            ///WindowModalで、親画面の中央に表示する例
            if (Owner != null)
            {
                Location = new Point(
                Owner.Location.X + (Owner.Width - Width) / 2,
                Owner.Location.Y + (Owner.Height - Height) / 2);
            }
        }
    }
}
