﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Terasoluna.TourSample.Client.Common.TourServiceReference;
using Terasoluna.SelectableValues;
using System.ServiceModel;
using Terasoluna.ServiceModel;
using Microsoft.Practices.Unity;

namespace Terasoluna.TourSample.Client.Common.BizLogic
{
    /// <summary>
    /// コードリストを取得するビジネスロジック
    /// </summary>
    public class CodeListBizLogic
    {
        /// <summary>
        /// エンドポイント名
        /// </summary>
        private const string EndpointName = "TourServicePort";

        /// <summary>
        /// UnityContainer
        /// </summary>
        [Dependency]
        public IUnityContainer Container { get; set; }

        /// <summary>
        ///　ツアー分類のコードリストを取得
        /// </summary>
        /// <returns></returns>
        public IList<SelectableValue> GetTourCategories()
        {
            List<SelectableValue> codeList = new List<SelectableValue>();                
            TourServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new TourServiceClient(EndpointName, address);
                TourCategoryDto[] result = client.FindAllTourCategories();
                client.Close();
                if (result != null)
                {
                    foreach (TourCategoryDto category in result)
                    {
                        codeList.Add(new SelectableValue(category.Name, category.Id));
                    }
                }
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                throw;
            }
            return codeList;
        }

        /// <summary>
        /// 出発地のコードリストを取得
        /// </summary>
        /// <returns></returns>
        public IList<SelectableValue> GetDeptPlaces()
        {
            List<SelectableValue> codeList = new List<SelectableValue>();
            TourServiceClient client = null;
            try
            {
                ///エンドポイントアドレスの取得
                ///WCF接続先変更機能により、接続先サーバアドレスを一律置換してくれる。
                EndpointAddress address = CommunicationManager.GetReplacedEndpointAddress(Container, EndpointName);
                client = new TourServiceClient(EndpointName, address);
                DeptPlaceDto[] result = client.FindAllDeptPlaces();
                client.Close();
                if (result != null)
                {
                    foreach (DeptPlaceDto deptPlace in result)
                    {
                        codeList.Add(new SelectableValue(deptPlace.Name, deptPlace.Id));
                    }
                }
            }
            catch (System.Exception)
            {
                if (client != null)
                {
                    client.Abort();
                }
                throw;
            }
            return codeList;
        }

    }
}
