﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.Windows.Forms.FormForward;
using Terasoluna.TourSample.Client.Common.View;
using Terasoluna.Windows.ViewModel.Validation;
using Terasoluna.TourSample.Client.B01.ViewData;
using Terasoluna.Windows.Forms.Events;
using Terasoluna.DataCopy;


namespace Terasoluna.TourSample.Client.B01.View
{
    /// <summary>
    /// ユーザ登録業務の大元の画面
    /// </summary>
    [ScreenId("SC_B01_03_01")]
    public partial class SC_B01_03_01View : TourSampleViewBase
    {
        /// <summary>
        /// 画面データ
        /// </summary>
        public object ViewData
        {
            get
            {
                object viewData = null;
                ///ContentPlaceHolder経由で表示中のパネルの画面データを取得
                ISC_B01_03_01MainContent mainContent = contentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
                if (mainContent != null)
                {
                    viewData = mainContent.ViewData;
                }

                return viewData;
            }
        }

        public SC_B01_03_01View()
        {
            InitializeComponent();
            //最初のパネルを追加
            contentPlaceHolder.ShowAndHideContent(typeof(SC_B01_03_00Control));
        }

        private void SC_B01_03_01View_Load(object sender, EventArgs e)
        {
        }

        /// <summary>
        /// 戻るボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void backButton_Click(object sender, EventArgs e)
        {
            ISC_B01_03_01MainContent mainContent = contentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
            if (mainContent != null)
            {
                mainContent.Back();
            }
        }

        /// <summary>
        /// 実行ボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void executeButton_Click(object sender, EventArgs e)
        {
            ISC_B01_03_01MainContent mainContent = contentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
            if (mainContent != null)
            {
                mainContent.Execute();
            }
        }

        /// <summary>
        /// ヘルプボタン押下
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void helpButton_Click(object sender, EventArgs e)
        {
            ISC_B01_03_01MainContent mainContent = contentPlaceHolder.CurrentContentControl as ISC_B01_03_01MainContent;
            if (mainContent != null)
            {
                ///ヘルプの取得
                string helpUrl = mainContent.HelpUrl;
                Help.ShowHelp(this, helpUrl);
            }
        }

        /// <summary>
        /// ContentPlaceHolderに、パネルが追加された時のイベント
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void contentPlaceHolder_ControlAdded(object sender, ControlEventArgs e)
        {
            ///追加されたパネルを取得
            ISC_B01_03_01MainContent mainContent = e.Control as ISC_B01_03_01MainContent;
            if (mainContent != null)
            {
                ///実行ボタンの文字列を設定
                executeButton.Text = mainContent.ExecuteButtonCaption;
                ///実行ボタンを表示するかを設定
                executeButton.Visible = mainContent.ExecutionEnabled;
                ///戻るボタンを表示するかを設定
                backButton.Visible = mainContent.BackEnabled;
                ///ヘルプボタンを表示するかを設定
                helpButton.Visible = mainContent.HelpEnabled;
                ///タイトルを設定
                this.Text = mainContent.Title;
                ///画面のヘッダー部に表示するログインユーザ情報をバインド設定
                userBindingSource.DataSource = mainContent.LoginUser;
            }
        }
    }
}
