﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Terasoluna.TourSample.Client.Common.Code;

namespace Terasoluna.TourSample.Client.A01.View
{
    /// <summary>
    /// ユーザ権限を選択するラジオボタン
    /// </summary>
    [DefaultBindingProperty("Role")]
    public partial class SC_B01_02_01_01UserControl : UserControl
    {
        private RoleEnum role = RoleEnum.User;

        public SC_B01_02_01_01UserControl()
        {
            InitializeComponent();
        }

        /// <summary>
        /// バインド対象のプロパティ
        /// </summary>
        [Bindable(true)]
        public RoleEnum Role
        {
            get
            {
                return role;
            }

            set
            {
                if (role != value)
                {
                    switch (value)
                    {
                        case RoleEnum.Admin:
                            role = value;
                            adminRadioButton.Checked = true;
                            OnRoleChanged(EventArgs.Empty);
                            break;                        
                        default:
                            role = value;
                            userRadioButton.Checked = true;
                            OnRoleChanged(EventArgs.Empty);
                            break;
                    }
                }
            }        
        }

        /// <summary>
        /// PropertyNamedChangeパターン
        /// </summary>
        public event EventHandler RoleChanged;

        /// <summary>
        /// RoleChangedイベントの発火
        /// </summary>
        /// <param name="e"></param>
        protected virtual void OnRoleChanged(EventArgs e)
        {
            EventHandler handler = RoleChanged;
            if (handler != null)
            {
                handler(this, e);
            }
        }

        /// <summary>
        /// 一般ユーザラジオボタンのチェック
        /// </summary>
        private void userRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (userRadioButton.Checked)
            {
                role = RoleEnum.User;
                OnRoleChanged(EventArgs.Empty);
            }
        }

        /// <summary>
        /// 管理者ラジオボタンのチェック
        /// </summary>
        private void adminRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (adminRadioButton.Checked)
            {
                role = RoleEnum.Admin;
                OnRoleChanged(EventArgs.Empty);
            }
        }
                 
    }
}
